/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client.pi;

import com.ibm.hsc.cim.client.HSCCIMClient;
import com.ibm.hsc.cim.client.pi.PIHSCCECCIMClient;
import com.ibm.hsc.cim.client.pi.PIHSCIOCIMClient;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCDlparClient;
import com.ibm.hsc.client.PIIOBusDataBean;
import com.ibm.hsc.client.PIIODrawerDataBean;
import com.ibm.hsc.client.PIIOSlotDataBean;
import com.ibm.hsc.client.PIVirtualEthernetDataBean;
import com.ibm.hsc.client.PIVirtualSCSIDataBean;
import com.ibm.hsc.client.PIVirtualSerialDataBean;
import com.ibm.hsc.client.PIVirtualSlotDataBean;
import com.ibm.hsc.client.rmc.HSCRMCException;
import com.ibm.hsc.client.rmc.PIHSCRMCClient;
import com.ibm.hsc.client.rmc.PIHSCRMCClientFactory;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.PIHscExceptionUtils;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.websm.diagnostics.IDebug;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbemcfg.GlobalConfig;

public class PIHscDlparCIMClient
extends HSCCIMClient
implements PIHSCDlparClient {
    protected PIHSCRMCClient mRMCClient = null;
    private CIMInstance m_lparInst = null;
    private String mCecIntName = null;
    private final String METHOD_DLPAR_ADD_MEM = "addMem";
    private final String METHOD_DLPAR_ADD_MEM_RMC = "addMemRMC";
    private final String METHOD_DLPAR_REMOVE_MEM = "removeMem";
    private final String METHOD_DLPAR_REMOVE_MEM_RMC = "removeMemRMC";
    private final String METHOD_DLPAR_MOVE_MEM = "moveMem";
    private final String METHOD_DLPAR_ADD_IO = "addIo";
    private final String METHOD_DLPAR_REMOVE_IO = "removeIo";
    private final String METHOD_DLPAR_MOVE_IO = "moveIo";
    private final String METHOD_VARY_ON_IO = "varyOnIo";
    private final String METHOD_VARY_OFF_IO = "varyOffIo";
    private final String RPA_PARTITION = "RPA_PARTITION";
    private final String OS400_PARTITION = "OS400_PARTITION";
    private final String METHOD_VARY_ON_MEMORY = "varyOnMemory";
    private final String METHOD_VARY_OFF_MEMORY = "varyOffMemory";
    private final String METHOD_OS400_RPA_CHECK = "OS400RPACheck";
    private final String METHOD_ADD_VIRTUAL_ETH = "addVirtualEthernet";
    private final String METHOD_ADD_VIRTUAL_SCSI_SERIAL = "addVirtualSerialSCSI";
    private final String METHOD_REMOVE_VIRTUAL_SLOTS = "removeVirtualSlots";
    private final String MOF_DEST_SLOT_ID = "DestinationSlotID";
    private final String MOF_PENDING_MEM = "PendingMem";
    private final String MOF_GET_MEM_INFO = "getMemInfo";
    private final String MOF_LPAR_SLOT_ID = "LPARSlotID";
    private final String PARTITION_NAME_SEP = "*";
    private final String MOF_PARTITION_TYPE = "PartitionType";
    private final String MOF_MEM_REGION = "memRegion";
    private final String MOF_DESIRED_BATCH_SIZE = "desiredBatchSize";
    private final String METHOD_START_BATCH_MODE = "startLparBatchMode";
    private final String METHOD_COMMIT_BATCH_MODE = "commitLparBatch";
    private final int DESIRED_BATCH_SIZE = 2;
    private final String MEM_CAPABLE = "mem";
    private final String CPU_CAPABLE = "cpu";
    private final String IO_CAPABLE = "io";
    private final int DEFAULT_TIMEOUT = 300;
    private final String MOF_GET_PROC_INFO = "getProcessorData";
    private final String MOF_LPAR_ID = "lparID";
    private final String MOF_CPU_LPAR_TASK = "CPULPARTask";
    private final String METHOD_ADD_CPU = "addCpu";
    private final String METHOD_REMOVE_CPU = "removeCpu";
    private final String METHOD_MOVE_CPU = "moveCpu";
    private final String MOF_CPU_QUANTITY = "numProcs";
    private final String MOF_PROC_UNIT_QUANTITY = "numProcUnits";
    private final String MOF_INTERACTIVE = "interactive";
    private final String MOF_UNCAPPED_WEIGHT = "uncappedWeight";
    private final String MOF_PROC_MODE = "ProcMode";
    private final String MOF_SHARING_MODE = "sharingMode";
    private final String MOF_TIMEOUT = "timeout";
    private final String VARY_ON_OFF_PROCESSING = "varyOnOffProcessing";
    private final String MOF_GET_IO_INFO = "getIoInfo";
    private final String MOF_GET_IO_SLOT_INFO = "getIoSlotInfo";
    private final String MOF_DRC_INDEX = "DRCIndex";
    private final String MOF_POOL_ID = "poolID";
    private final String MOF_PHY_LOCATION = "PhyLocCode";
    private final String MOF_DEST_SLOT_INDEX = "DestinationSlotIndex";
    private final String MOF_BUS = "busId";
    private final String MOF_MAX_INDEX = "maxIndex";
    private final String MOF_CLEAR_FLAG = "clearFlag";
    private final String MOF_OP = "op";
    private final String MOF_DLPAR_RMC_CONNECTION = "noRMCConnection";
    private final String MOF_DLPAR_DESTINATION_NAME = "destination";
    private final String MOF_DLPAR_DEST_LPAR_ID = "destLparID";
    private final String MOF_DLPAR_QUANTITY = "quantity";
    private final String MOF_DLPAR_TIMEOUT = "timeout";
    private final String MOF_DLPAR_DETAIL = "detail";
    private final String MOF_DLPAR_CEC_INT_NAME = "cecIntName";
    private final String MOF_DLPAR_DEST_PEND_MEM = "destPendingMem";
    private final String MOF_DETAIL_LEVEL = "detailLevel";
    private final String MOF_NO_RMC_CONNECTION = "noRMCConnection";
    private final String MOF_RMC_OPERATION = "operation";
    private final String MOF_OPERATION = "operation";
    private final String MOF_DESIRED_PROCESSING = "desiredProcessing";
    private final String VARY_ON_OFF_PHB = "varyOnOffPHB";
    private final String MOF_DEST_LPAR_ID = "DestinationLparID";
    private final String MOF_SRC_LPAR_ID = "SrcLparID";
    private final String MOF_PHB_DRC_NAME = "PhbDrcName";
    private int NO_PROCS = -1;
    private long NO_PROC_UNITS = -1L;
    private short NO_SHARING_MODE = (short)-1;
    private int NO_UNCAPPED_WEIGHT = -1;
    private int NO_INTERACTIVE = -1;
    private final short UNASSIGNED_IO = (short)-1;
    private short SHARING_MODE_CAPPED = 0;
    private short SHARING_MODE_UNCAPPED = 1;
    private int NO_POOL_ID = 65536;
    private final short VARY_OFF = 0;
    private final short VARY_ON = 1;
    private final String IS_ERROR = "IsError";
    private final String INFO_MSG = "InfoMsg";
    private final String PROC_SUCCESS = "ProcSuccess";
    private final String PROC_UNIT_SUCCESS = "ProcUnitSuccess";
    private final String UNCAPPED_WEIGHT_SUCCESS = "UncappedWeightSuccess";
    private static final short IO_SUCCESS = 1;
    private static final short IO_FAILURE = 0;
    private static final String BUS_SLOT_INFO = "busSlotInfo";
    private static final String BUS_HAS_ACTIVE_SLOTS = "busHasActiveSlots";
    private static final String BUS_DRC_NAME = "busDRCName";
    private final String MOF_SLOT_NUM = "slotNum";
    private final String MOF_IEEE = "ieee";
    private final String MOF_VLAN_ID = "vlanID";
    private final String MOF_LENGTH = "addLength";
    private final String MOF_ADD_VLAN_ID = "addVlanIDs";
    private final String MOF_TRUNK = "trunk";
    private final String MOF_REQUIRED = "Required";
    private final String MOF_DEVICE_CLASS = "deviceClass";
    private final String MOF_DEVICE_ATTR = "deviceAttr";
    private final String MOF_SUPPORT_HMC = "supportHMC";
    private final String MOF_SERVER_LPAR_ID = "serverLparId";
    private final String MOF_SERVER_V_SLOT_NUM = "serverVirtualSlot";
    private final String MOF_RMC_CONNECTION = "rmcConnection";
    private static final UnsignedInt8 DEVICE_CLASS_SCSI = new UnsignedInt8(3);
    private static final UnsignedInt8 DEVICE_CLASS_SERIAL = new UnsignedInt8(2);
    private static final UnsignedInt8 NO_HMC_SUPPORT = new UnsignedInt8(0);
    private static final String DLPAR_BUNDLE_NAME = "PIDLPARBundle";
    protected static final String INFO_ADD_RPA = "RPA adding {0} ......\n";
    protected static final String INFO_REMOVE_RPA = "RPA removing {0} .....\n";
    protected static final String INFO_ADD_HMC = "HMC adding {0} ......\n";
    protected static final String INFO_REMOVE_HMC = "HMC removing {0} ......\n";
    protected static final String INFO_MOVE_HMC = "HMC moving {0} ......\n";
    protected static final String INFO_ADD_SUCC = "HMC adding of {0} operation finished successfully.\n";
    protected static final String INFO_CPU_RES = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "INFO_CPU_RES", "processor");
    protected static final String INFO_PROCESSING_RES = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "INFO_PROCESSING_RES", "processing resources");
    protected static final String INFO_MEM_RES = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "INFO_MEM_RES", "memory");
    protected static final String INFO_ADD_HMC_SUCC = "HMC adding {0} operation finished successfully.\n";
    protected static final String INFO_REMOVE_HMC_SUCC = "HMC removing {0} operation finished successfully.\n";
    protected static final String INFO_HMC_ROLLBACK_SUCC = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "INFO_HMC_ROLLBACK_SUCC", "HMC rollback operation finished successfully.\n");
    protected static final String INFO_HMC_ROLLBACK_ADD = "HMC rollback after AIX failed on adding {0} ......\n";
    protected static final String INFO_HMC_ROLLBACK_REMOVE = "HMC rollback after AIX failed on removing {0} .....\n";
    protected static final String INFO_SLOT_RES = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "INFO_SLOT_RES", "I/O slot");
    protected static final String INVALID_SLOT_ARGUMENT_SPECIFIED = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "INVALID_SLOT_ARGUMENT_SPECIFIED", "Invalid slot argument specified.");
    protected static final String ERR_SLOT_REQUIRED = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_SLOT_REQUIRED", "The I/O slot is required. It cannot be moved or removed.");
    protected static final String ERR_SLOT_NOT_STOPPED = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_SLOT_NOT_STOPPED", "The I/O slot with an invalid state or status.");
    protected static final String ERR_SLOT_SAME_GROUP = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_SLOT_SAME_GROUP", "There is a I/O slot in the same group has a invalid state or status.");
    protected static final String ERR_SLOT_SRC_PAR = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_SLOT_SRC_PAR", "The slot doesn't belong to the source logical partition.");
    protected static final String ERR_SLOT_OP_FAILED = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_SLOT_OP_FAILED", "The actual HMC DLPAR operation failed with exception.");
    protected static final String ERR_SLOT_NOT_MATCH = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_SLOT_NOT_MATCH", "The given slot id and drawer id doesn't match.");
    protected static final String ERR_SLOT_HMC = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_SLOT_HMC", "HMCERRV3DLPAR021: HMC I/O slot DLPAR operation failed without throwing exception. Here is the failed I/O DrawerID/SlotID and the failed reason list:\n");
    protected static final String ERR_OUT_OF_SYNC = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_OUT_OF_SYNC", "The above HMC DLPAR operation failure may cause the data in HMC and AIX out of sync. If that happens, you may need to reboot the logical partition.\n");
    protected static final String ERR_HMC_EXCEPTION = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_HMC_EXCEPTION", "HMCERRV3DLPAR022: HMC DLPAR operation failed with throwing an exception. The data in HMC and AIX may out of sync. If that happens, you may need to reboot the logical partition.");
    protected static final String INFO_VIRTUAL_RES = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "INFO_VIRTUAL_RES", "Virtual I/O");
    protected static final String ERR_SLOT_EXISTS = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_SLOT_EXISTS", "The Virtual slot id specified already exists.");
    protected static final String ERR_INVALID_SLOT_RANGE = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_INVALID_SLOT_RANGE", "The Virtual slot id specified is not in the valid range.");
    protected static final String ERR_INVALID_VLAN_RANGE = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_INVALID_VLAN_RANGE", "The Port Vlan id is not in the valid range");
    protected static final String ERR_INVALID_ADD_VLAN_RANGE = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_INVALID_ADD_VLAN_RANGE", "The Additional Vlan id is not in the valid range");
    protected static final String ERR_ADD_VLAN_ID_NOT_ALLOWED = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_ADD_VLAN_ID_NOT_ALLOWED", "Additional virtual LAN IDs cannot be specified for a virtual ethernet adapter that is not IEEE compliant.");
    protected static final String ERR_TOO_MANY_VLAN_IDS = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_TOO_MANY_VLAN_IDS", "Too many additional virtual LAN IDs has been defined for the virtual ethernet adapter.");
    protected static final String ERR_DUPLICATE_VLAN_IDS = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_DUPLICATE_VLAN_IDS", "The virtual ethernet adapter is incorrect because it has duplicate virtual LAN IDs.");
    protected static final String ERR_INVALID_IEEE_VALUE = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_INVALID_IEEE_VALUE", "An invalid IEEE value was specified.");
    protected static final String ERR_INVALID_DEVICE_ATTR_VALUE = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_INVALID_DEVICE_ATTR_VALUE", "An invalid virtual device attribute value was specified.");
    protected static final String ERR_INVALID_REQ_DES_FLAG = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_INVALID_REQ_DES_FLAG", "An invalid desired/required flag was specified.");
    protected static final String ERR_INVALID_SERV_LPAR_ID = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_INVALID_SERV_LPAR_ID", "An invalid server lpar id was specified.");
    protected static final String ERR_INVALID_SERV_SLOT_ID = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_INVALID_SERV_SLOT_ID", "An invalid server slot id was specified.");
    protected static final String ERR_INVALID_HMC_SUPPORT_VALUE = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_INVALID_HMC_SUPPORT_VALUE", "An invalid HMC support value was specified.");
    protected static final String ERR_VIRTUAL_DOES_NOT_EXISTS = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_VIRTUAL_DOES_NOT_EXISTS", "The virtual slot specified does not exists");
    protected static final String ERR_GOT_EXCEPTION_CLEARING = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_GOT_EXCEPTION_CLEARING", "The virtual slot got an exception trying to do roll back.");
    protected static final String ERR_INVALID_DEVICE_DEV_CLASS = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_INVALID_DEVICE_DEV_CLASS", "An invalid virtual device class attribute value was specified.");
    protected static final String ERR_GOT_EXCEPTION_VARYING_ONOFF = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_GOT_EXCEPTION_VARYING_ONOFF", "Got an exception varying on/off the virtual slot.");
    protected static final String ERR_EXCEP_DRC_UNABLE_TO_UNSET = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_EXCEP_DRC_UNABLE_TO_UNSET", "Got an exception trying to do roll back due to an exception getting the drcIndex and the drcName of the slot.");
    protected static final String ERR_GOT_EXCEPTION_GETTING_DRCNAME_INDEX = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_GOT_EXCEPTION_GETTING_DRCNAME_INDEX", "Got an exception getting the drcIndex and the drcName of the slot.");
    protected static final String ERR_RMC_OPERATION_FAILED = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_RMC_OPERATION_FAILED", "The RMC operation failed.");
    protected static final String ERR_RMC_RESET_FAILED = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_RMC_RESET_FAILED", "The RMC operation failed and the roll back also failed.");
    protected static final String ERR_VARYONOFF_RESET_FAILED = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_VARYONOFF_RESET_FAILED", "The Vary on/off operation failed and the roll back of the slot also failed.");
    protected static final String ERR_INVALID_TRUNK_VALUE = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_INVALID_TRUNK_VALUE", "An invalid trunk adapter value was specified.");
    protected static final String ERR_SCSI_SERVER_NOT_ALLOWED = HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "07C0");
    protected static final String ERR_SERIAL_CLIENT_NOT_ALLOWED = HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "07C1");
    protected static final String ERR_VIRTUAL_HMC = HSCResourceBundleUtil.getMessage("PIDLPARBundle", "ERR_VIRTUAL_HMC", "HMCERRV5DLPAR001: HMC Virtual slot DLPAR operation failed without throwing exception. Here is the failed Virtual SlotID and the failed reason list:\n");

    private PIHscDlparCIMClient(String string, PIHSCCECCIMClient pIHSCCECCIMClient, String string2, CIMObjectPath cIMObjectPath, String string3) throws PIHscClientException {
        super(string, pIHSCCECCIMClient, string2, cIMObjectPath, string3);
        PIHSCRMCClientFactory pIHSCRMCClientFactory;
        this.debug1("in PIHscDlparCIMClient()");
        try {
            this.debug1("getting RMC client");
            pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(pIHSCCECCIMClient.getIntName());
            this.mRMCClient = pIHSCRMCClientFactory.createRMCClient(string2);
            this.mCecIntName = pIHSCCECCIMClient.getIntName();
        }
        catch (HSCException hSCException) {
            this.debug1("Error while creating RMC client : " + hSCException.toString());
            HSCLogUtils.clientLog(hSCException, HSCLogUtils._DLPARClassLogInfo);
        }
        if (null == string2) {
            try {
                pIHSCRMCClientFactory = PIHscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, "Name");
                this.mIntName = (String)pIHSCRMCClientFactory.getValue();
            }
            catch (CIMException cIMException) {
                HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
                PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
                if (pIHscClientException == null) {
                    pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
                }
                throw pIHscClientException;
            }
        }
    }

    public static PIHscDlparCIMClient createInstance(String string, String string2, String string3, boolean bl, String string4) throws PIHscClientException {
        CIMObjectPath cIMObjectPath = null;
        String string5 = "";
        String string6 = null;
        CIMObjectPath cIMObjectPath2 = null;
        PIHscDlparCIMClient pIHscDlparCIMClient = null;
        PIHscDlparCIMClient.debug("in createInstance()");
        try {
            CIMObjectPath cIMObjectPath3;
            Object object;
            PIHSCCECCIMClient pIHSCCECCIMClient = null;
            pIHSCCECCIMClient = PIHSCCECCIMClient.createInstance(string, string2, false, string4);
            PIHscDlparCIMClient.debug("cecClient : " + pIHSCCECCIMClient);
            if (pIHSCCECCIMClient == null) {
                PIHscDlparCIMClient.debug("cecClient is null");
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MANAGED_SYSTEM_NOT_FOUND", null, null);
            }
            string5 = pIHSCCECCIMClient.getIntName();
            if (bl) {
                object = "";
                string6 = string3.indexOf(42) == -1 ? string3 + "*" + string5 : string3;
                PIHscDlparCIMClient.debug("isIntName = true");
                PIHscDlparCIMClient.debug("intName: " + string6);
                cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", string4);
                cIMObjectPath.addKey("Name", new CIMValue((Object)string6.trim()));
                cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                cIMObjectPath3 = null;
                try {
                    cIMObjectPath3 = PIHscUtil.getCIMInstance(string, cIMObjectPath, false);
                }
                catch (Throwable throwable) {
                    PIHscDlparCIMClient.debug("NO LPAR INSTANCE");
                    throwable.printStackTrace();
                    cIMObjectPath3 = null;
                }
                if (cIMObjectPath3 == null) {
                    PIHscDlparCIMClient.debug("lparInst = null");
                    return null;
                }
                cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", cIMObjectPath3.getKeyValuePairs());
                cIMObjectPath.setNameSpace(string4);
                PIHscDlparCIMClient.debug("intNameOp = " + cIMObjectPath);
            } else {
                object = pIHSCCECCIMClient.getPartitionObjectPaths();
                while (object.hasMoreElements()) {
                    cIMObjectPath3 = (CIMObjectPath)object.nextElement();
                    CIMValue cIMValue = PIHscUtil.getCIMAttribute(string, cIMObjectPath3, "Name");
                    string6 = (String)cIMValue.getValue();
                    PIHscDlparCIMClient.debug("intName : " + string6);
                    PIHscDlparCIMClient.debug("isIntName = false");
                    if (string3.equals(string6.substring(0, string6.indexOf("*")))) {
                        cIMObjectPath = cIMObjectPath3;
                    }
                    if (string3.equals(string6)) {
                        PIHscDlparCIMClient.debug("in lpar id and int check");
                        cIMObjectPath = cIMObjectPath3;
                    }
                    if (bl) continue;
                    cIMValue = PIHscUtil.getCIMAttribute(string, cIMObjectPath3, "UserDefinedName");
                    String string7 = string3.trim();
                    String string8 = ((String)cIMValue.getValue()).trim();
                    PIHscDlparCIMClient.debug("lpar : " + string7);
                    PIHscDlparCIMClient.debug("val : " + string8);
                    if (!string7.equals(string8)) continue;
                    cIMObjectPath2 = cIMObjectPath3;
                    break;
                }
            }
            if (cIMObjectPath2 == null && cIMObjectPath == null) {
                return null;
            }
            if (cIMObjectPath2 != null) {
                cIMObjectPath = cIMObjectPath2;
                PIHscDlparCIMClient.debug("user name was sent down - intNameOp = " + cIMObjectPath);
            }
            object = PIHscUtil.getCIMInstance(string, cIMObjectPath, false);
            int n = ((UnsignedInt8)object.getProperty("PartitionState").getValue().getValue()).intValue();
            PIHscDlparCIMClient.debug("lparState : " + n);
            PIHscDlparCIMClient.debug("powered off state : 0");
            if (0 == n) {
                PIHscDlparCIMClient.debug("partition is powered off");
                throw new PIHscClientException("8000", DLPAR_BUNDLE_NAME, "LPAR_NOT_IN_RUNNING_STATE", null, null);
            }
            pIHscDlparCIMClient = new PIHscDlparCIMClient(string, pIHSCCECCIMClient, string6, cIMObjectPath, string4);
            PIHscDlparCIMClient.debug("dlparClient created for " + string6);
            pIHscDlparCIMClient.setLparInst((CIMInstance)object);
        }
        catch (CIMException cIMException) {
            PIHscDlparCIMClient.debug("could not create a dlpar client");
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        return pIHscDlparCIMClient;
    }

    public boolean isRMCConnectionExist() throws PIHscClientException {
        this.debug1("in isRMCConnectionExist()");
        int n = 0;
        try {
            CIMValue cIMValue = this.m_lparInst.getProperty("DLPARCapabilities").getValue();
            if (cIMValue != null) {
                UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMValue.getValue();
                PIHscDlparCIMClient.debug("rmc value = " + unsignedInt32.toString());
                n = unsignedInt32.intValue();
            }
            this.debug1("DLPAR Capabilities value : " + n);
        }
        catch (Exception exception) {
            this.debug1("Error while getting DLPAR Capabilities in isRMCConnectionExist() : " + exception.toString());
            exception.printStackTrace();
        }
        if (n == 0) {
            this.debug1("R M C   Connection does not exist");
            return false;
        }
        this.debug1("R M C   Connection exists");
        return true;
    }

    public Hashtable getMoveToPartitionNames(String string) throws PIHscClientException {
        Hashtable hashtable = new Hashtable();
        this.debug1("in getMoveToPartitionNames()");
        PIHSCCECCIMClient pIHSCCECCIMClient = (PIHSCCECCIMClient)this.mParentObject;
        Hashtable hashtable2 = pIHSCCECCIMClient.getMoveToParNames(this.mIntName, string);
        if (hashtable2 != null) {
            Vector vector = (Vector)hashtable2.get("usrNames");
            this.debug1("dest = " + vector.toString());
            Vector<String> vector2 = new Vector<String>(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                try {
                    PIHscDlparCIMClient pIHscDlparCIMClient = PIHscDlparCIMClient.createInstance(this.mHostName, this.mParentObject.getIntName(), (String)vector.elementAt(i), false, "root/ibmhscS1_0");
                    vector2.addElement(pIHscDlparCIMClient.getPartitionType());
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.debug1("lparTypes = " + vector2.toString());
            hashtable2.put("runningLParTypes", vector2);
            return hashtable2;
        }
        return hashtable;
    }

    public UnsignedInt16[] getOptimalInteractiveRange(UnsignedInt32 unsignedInt32) throws PIHscClientException {
        this.debug1("in getOptimalInteractiveRange()");
        PIHSCCECCIMClient pIHSCCECCIMClient = (PIHSCCECCIMClient)this.mParentObject;
        return pIHSCCECCIMClient.queryOptimalInteractiveRange(unsignedInt32);
    }

    public Hashtable getMemoryData() throws PIHscClientException {
        this.debug1("in getMemoryData()");
        Trace.trace("accmhscT", "->PIHscDlparCIMClient.getMemoryData");
        try {
            Vector vector = this.getInputVector(this.mIntName);
            Vector vector2 = new Vector();
            PIHscDlparCIMClient.debug("calling getMemInfo() on provider");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "getMemInfo", vector, vector2);
            Hashtable<String, Number> hashtable = new Hashtable<String, Number>();
            long l = 0L;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            if (!(vector2.elementAt(0) instanceof CIMValue)) {
                l = ((UnsignedInt32)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).longValue();
                n = ((UnsignedInt32)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).intValue();
                n2 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(2)).getValue().getValue()).intValue();
                n3 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(3)).getValue().getValue()).intValue();
                n4 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(4)).getValue().getValue()).intValue();
                n5 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(5)).getValue().getValue()).intValue();
                n6 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(6)).getValue().getValue()).intValue();
                n7 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(7)).getValue().getValue()).intValue();
                n8 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(8)).getValue().getValue()).intValue();
                n9 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(9)).getValue().getValue()).intValue();
                n10 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(10)).getValue().getValue()).intValue();
            }
            hashtable.put("availMem", new Long(l));
            hashtable.put("minMem", new Integer(n));
            hashtable.put("maxMem", new Integer(n2));
            hashtable.put("currMinMem", new Integer(n3));
            hashtable.put("currAllocMem", new Integer(n4));
            hashtable.put("currMaxMem", new Integer(n5));
            hashtable.put("pendMinMem", new Integer(n6));
            hashtable.put("pendAllocMem", new Integer(n7));
            hashtable.put("pendMaxMem", new Integer(n8));
            hashtable.put("runtimeMem", new Integer(n9));
            hashtable.put("runtimeMinMem", new Integer(n10));
            Trace.trace("accmhscT", "<-PIHscDlparCIMClient.getMemoryData");
            return hashtable;
        }
        catch (CIMException cIMException) {
            PIHscDlparCIMClient.debug("Error getting getMemInfo()");
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public int addMem(int n, int n2, int n3, short s, boolean bl) throws PIHscClientException, HSCRMCException {
        Trace.trace("accmhscT", "->PIHscDlparCIMClient.addMem");
        this.debug1("in addMem()");
        int n4 = 0;
        String string = this.getPartitionType();
        short s2 = this.getPartitionSlotId(this.mIntName);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        vector.addElement(new CIMProperty("DestinationSlotID", new CIMValue((Object)new UnsignedInt16((int)s2))));
        vector.addElement(new CIMProperty("PendingMem", new CIMValue((Object)new UnsignedInt32((long)n2))));
        vector.addElement(new CIMProperty("quantity", new CIMValue((Object)new UnsignedInt32((long)n))));
        vector.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n3))));
        vector.addElement(new CIMProperty("detail", new CIMValue((Object)new UnsignedInt16((int)s))));
        vector.addElement(new CIMProperty("cecIntName", new CIMValue((Object)new String(this.mCecIntName))));
        vector.addElement(new CIMProperty("noRMCConnection", new CIMValue((Object)new Boolean(bl))));
        this.debug1("inParms count = " + vector.size());
        try {
            this.debug1("calling addMem() on provider");
            this.doDlparMemOperation("addMem", vector);
            n4 = n2 + n;
        }
        catch (PIHscClientException pIHscClientException) {
            this.debug1("Error calling addMem() on provider : " + pIHscClientException.toString());
            pIHscClientException.printStackTrace();
            HSCLogUtils.clientLog(pIHscClientException, HSCLogUtils._DLPARClassLogInfo);
            throw pIHscClientException;
        }
        Trace.trace("accmhscT", "<-PIHscDlparCIMClient.getMemoryData");
        return n4;
    }

    public int removeMem(int n, int n2, int n3, short s, boolean bl) throws PIHscClientException, HSCRMCException {
        this.debug1("in removeMem()");
        Trace.trace("accmhscT", "->PIHscDlparCIMClient.removeMem");
        int n4 = 0;
        String string = this.getPartitionType();
        short s2 = this.getPartitionSlotId(this.mIntName);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        vector.addElement(new CIMProperty("DestinationSlotID", new CIMValue((Object)new UnsignedInt16((int)s2))));
        vector.addElement(new CIMProperty("PendingMem", new CIMValue((Object)new UnsignedInt32((long)n2))));
        vector.addElement(new CIMProperty("quantity", new CIMValue((Object)new UnsignedInt32((long)n))));
        vector.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n3))));
        vector.addElement(new CIMProperty("detail", new CIMValue((Object)new UnsignedInt16((int)s))));
        vector.addElement(new CIMProperty("cecIntName", new CIMValue((Object)new String(this.mCecIntName))));
        vector.addElement(new CIMProperty("noRMCConnection", new CIMValue((Object)new Boolean(bl))));
        try {
            this.debug1("calling removeMem() on provider");
            this.doDlparMemOperation("removeMem", vector);
            n4 = n2 - n;
        }
        catch (PIHscClientException pIHscClientException) {
            this.debug1("Error calling removeMem() : " + pIHscClientException.toString());
            pIHscClientException.printStackTrace();
            HSCLogUtils.clientLog(pIHscClientException, HSCLogUtils._DLPARClassLogInfo);
            throw pIHscClientException;
        }
        Trace.trace("accmhscT", "<-PIHscDlparCIMClient.removeMem");
        return n4;
    }

    public int moveMem(int n, String string, boolean bl, int n2, short s, boolean bl2) throws PIHscClientException, HSCRMCException {
        this.debug1("in moveMem()");
        int n3 = 0;
        Hashtable hashtable = this.getMemoryData();
        n3 = (Integer)hashtable.get("pendAllocMem");
        int n4 = 0;
        PIHscDlparCIMClient pIHscDlparCIMClient = PIHscDlparCIMClient.createInstance(this.mHostName, this.mParentObject.getIntName(), string, bl, "root/ibmhscS1_0");
        hashtable = pIHscDlparCIMClient.getMemoryData();
        n4 = (Integer)hashtable.get("pendAllocMem");
        boolean bl3 = false;
        bl3 = !this.isRMCConnectionExist();
        return this.moveMem(n, n3, n4, string, false, n2, s, bl2, this.getPartitionType(), pIHscDlparCIMClient.getPartitionType());
    }

    public int moveMem(int n, int n2, int n3, String string, boolean bl, int n4, short s, boolean bl2, String string2, String string3) throws PIHscClientException, HSCRMCException {
        this.debug1("in moveMem()");
        Trace.trace("accmhscT", "->PIHscDlparCIMClient.moveMem");
        int n5 = 0;
        PIHscDlparCIMClient pIHscDlparCIMClient = null;
        Object var13_13 = null;
        Object var14_14 = null;
        pIHscDlparCIMClient = PIHscDlparCIMClient.createInstance(this.mHostName, this.mParentObject.getIntName(), string, bl, "root/ibmhscS1_0");
        short s2 = this.getPartitionSlotId(this.mIntName);
        short s3 = pIHscDlparCIMClient.getPartitionSlotId(pIHscDlparCIMClient.mIntName);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        vector.addElement(new CIMProperty("DestinationSlotID", new CIMValue((Object)new UnsignedInt16((int)s2))));
        vector.addElement(new CIMProperty("PendingMem", new CIMValue((Object)new UnsignedInt32((long)n2))));
        vector.addElement(new CIMProperty("quantity", new CIMValue((Object)new UnsignedInt32((long)n))));
        vector.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n4))));
        vector.addElement(new CIMProperty("detail", new CIMValue((Object)new UnsignedInt16((int)s))));
        vector.addElement(new CIMProperty("cecIntName", new CIMValue((Object)new String(this.mCecIntName))));
        vector.addElement(new CIMProperty("noRMCConnection", new CIMValue((Object)new Boolean(bl2))));
        vector.addElement(new CIMProperty("destination", new CIMValue((Object)new String(string))));
        vector.addElement(new CIMProperty("destLparID", new CIMValue((Object)new UnsignedInt16((int)s3))));
        vector.addElement(new CIMProperty("destPendingMem", new CIMValue((Object)new UnsignedInt32((long)n3))));
        try {
            this.debug1("calling moveMem() on provider");
            this.doDlparMemOperation("moveMem", vector);
            n5 = n2 - n;
        }
        catch (PIHscClientException pIHscClientException) {
            this.debug1("Error calling removeMem() on provider");
            HSCLogUtils.clientLog(pIHscClientException, HSCLogUtils._DLPARClassLogInfo);
            pIHscClientException.printStackTrace();
            throw pIHscClientException;
        }
        Trace.trace("accmhscT", "<-PIHscDlparCIMClient.moveMem");
        return n5;
    }

    public int addIo(String[] stringArray, Integer[] integerArray, int n, short s, boolean bl) throws PIHscClientException, HSCRMCException {
        return this.addIo(this, stringArray, integerArray, n, s, bl);
    }

    public int removeIo(String[] stringArray, Integer[] integerArray, int n, short s, boolean bl) throws PIHscClientException, HSCRMCException {
        return this.removeIo(this, stringArray, integerArray, n, s, bl);
    }

    public int moveIo(String[] stringArray, Integer[] integerArray, String string, boolean bl, int n, short s, boolean bl2) throws PIHscClientException, HSCRMCException {
        int n2;
        boolean bl3 = false;
        Hashtable hashtable = null;
        PIIOSlotDataBean pIIOSlotDataBean = null;
        boolean bl4 = false;
        boolean bl5 = false;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Hashtable hashtable2 = new Hashtable();
        boolean[] blArray = null;
        String[] stringArray2 = null;
        UnsignedInt32[] unsignedInt32Array = null;
        UnsignedInt16[] unsignedInt16Array = null;
        int n3 = 0;
        boolean bl6 = false;
        String string2 = null;
        int n4 = this.lparId(this);
        System.out.println("moveIo: lparID = " + n4);
        Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
        Hashtable<String, Integer> hashtable4 = new Hashtable<String, Integer>();
        String string3 = this.getMessage("INFO_MOVE_HMC", INFO_MOVE_HMC, new String[]{INFO_SLOT_RES});
        PIHscDlparCIMClient pIHscDlparCIMClient = null;
        System.out.println("destination = " + string);
        System.out.println("mHostName = " + this.mHostName);
        pIHscDlparCIMClient = PIHscDlparCIMClient.createInstance(this.mHostName, this.mParentObject.getIntName(), string, bl, "root/ibmhscS1_0");
        if (pIHscDlparCIMClient == null) {
            throw new PIHscClientException("05DF", DLPAR_BUNDLE_NAME, "ERR_SLOT_OP_FAILED");
        }
        hashtable = this.getIoData(pIHscDlparCIMClient);
        if (integerArray[0] == this.NO_POOL_ID) {
            pIIOSlotDataBean = this.getIoSlot(hashtable, stringArray[0]);
            if (null == pIIOSlotDataBean) {
                throw new PIHscClientException("05DF", DLPAR_BUNDLE_NAME, "ERR_SLOT_OP_FAILED");
            }
            UnsignedInt16 unsignedInt16 = pIIOSlotDataBean.getIoPool();
            integerArray[0] = unsignedInt16 == null ? new Integer(65535) : new Integer(unsignedInt16.intValue());
        }
        n3 = stringArray.length;
        blArray = new boolean[n3];
        stringArray2 = new String[n3];
        unsignedInt32Array = new UnsignedInt32[n3];
        unsignedInt16Array = new UnsignedInt16[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            pIIOSlotDataBean = this.getIoSlot(hashtable, stringArray[n2]);
            if (pIIOSlotDataBean == null) {
                blArray[n2] = false;
                bl4 = true;
                long l = Long.parseLong(stringArray[n2]);
                System.out.println(" INVALID_SLOT_ARGUMENT_SPECIFIED: no data bean for slot.... " + Long.toString(l, 16));
                string3 = string3 + INVALID_SLOT_ARGUMENT_SPECIFIED;
                string3 = string3 + " ";
                string3 = string3 + Long.toString(l, 16);
                continue;
            }
            UnsignedInt16 unsignedInt16 = pIIOSlotDataBean.getOwner();
            if (pIIOSlotDataBean.getOwnerId().intValue() != n4 || pIIOSlotDataBean.getOwnerClass().shortValue() != 2) {
                blArray[n2] = false;
                bl4 = true;
                long l = Long.parseLong(stringArray[n2]);
                System.out.println(" ERR_SLOT_SRC_PAR: The slot doesn't belong to the source logical partition." + Long.toString(l, 16));
                string3 = string3 + ERR_SLOT_SRC_PAR;
                string3 = string3 + " ";
                string3 = string3 + Long.toString(l, 16);
                continue;
            }
            if (this.isRPA(pIHscDlparCIMClient)) {
                Object object;
                boolean bl7 = PIHscUtil.underIOPAndStorageDev(pIIOSlotDataBean);
                if (bl7) {
                    long l = Long.parseLong(stringArray[n2]);
                    object = HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "063F");
                    string3 = string3 + (String)object + " " + Long.toString(l, 16);
                }
                if (!bl2) {
                    String string4 = pIIOSlotDataBean.getBusID();
                    Integer n5 = (Integer)hashtable3.get(string4);
                    if (n5 != null) {
                        int n6 = n5 + 1;
                        hashtable3.put(string4, new Integer(n6));
                        System.out.println("PHB already varied ON --------------------");
                        System.out.println("numSlotsUnderPHB = " + n6);
                        blArray[n2] = true;
                        unsignedInt32Array[n2] = new UnsignedInt32(stringArray[n2]);
                        unsignedInt16Array[n2] = new UnsignedInt16(integerArray[n2].intValue());
                        stringArray2[n2] = pIIOSlotDataBean.getDrcName();
                        continue;
                    }
                    if (!this.busHasActiveSlots(string4, this.lparId(pIHscDlparCIMClient), hashtable)) {
                        object = this.getIoBus(hashtable, string4);
                        string2 = ((PIIOBusDataBean)object).getBusDrcName();
                        System.out.println("Call to vary on PHB. phb DRC name = " + string2);
                        try {
                            Hashtable hashtable5 = this.varyOnOffPHB(string2, n, s, "a", this.lparId(pIHscDlparCIMClient), bl2);
                            boolean bl8 = (Boolean)hashtable5.get("IsError");
                            if (bl8) {
                                blArray[n2] = false;
                                bl4 = true;
                                string3 = string3 + (String)hashtable5.get("InfoMsg");
                                continue;
                            }
                            System.out.println("ADDING PHB " + string4);
                            hashtable3.put(string4, new Integer(1));
                        }
                        catch (Throwable throwable) {
                            blArray[n2] = false;
                            bl4 = true;
                            string3 = string3 + throwable.getMessage();
                            continue;
                        }
                    }
                }
            }
            blArray[n2] = true;
            unsignedInt32Array[n2] = new UnsignedInt32(stringArray[n2]);
            unsignedInt16Array[n2] = new UnsignedInt16(integerArray[n2].intValue());
            stringArray2[n2] = pIIOSlotDataBean.getDrcName();
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            System.out.println("physical location codes = " + stringArray2[n2]);
        }
        hashtable2.put("DRCIndex", unsignedInt32Array);
        hashtable2.put("PhyLocCode", stringArray2);
        hashtable2.put("poolID", unsignedInt16Array);
        if (bl4) {
            hashtable2 = this.slotInfoTrim(hashtable2, blArray, false);
        }
        if (hashtable2.size() == 0) {
            System.out.println(" got trimmed totally --- ");
            throw new PIHscClientException("2930", "HSCCIMExceptionBundle", "2930", new String[]{string3});
        }
        try {
            vector = this.doDlparIoOperation("moveIo", hashtable2, pIHscDlparCIMClient, n, s, bl2);
            System.out.println("returned from doDlparIoOperation......................");
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
            if (!(throwable instanceof PIHscClientException)) {
                string3 = string3 + throwable.getMessage();
                System.out.println(" got an except = " + string3);
                throw new PIHscClientException("2930", "HSCCIMExceptionBundle", "2930", new String[]{string3});
            }
            System.out.println(" got an PIHscClientException except = " + string3);
            throw (PIHscClientException)throwable;
        }
        if (null != vector) {
            string3 = string3 + (String)vector.elementAt(0);
            blArray = (boolean[])vector.elementAt(1);
            hashtable2 = this.slotInfoTrim(hashtable2, blArray, false);
            bl4 = true;
        }
        if (this.isRPA(this) && hashtable2.size() != 0 && !bl2) {
            UnsignedInt32[] unsignedInt32Array2 = (UnsignedInt32[])hashtable2.get("DRCIndex");
            blArray = new boolean[unsignedInt32Array2.length];
            System.out.println("REFRESHING ioData for src ----------------------");
            hashtable = this.getIoData(this);
            for (int i = 0; i < unsignedInt32Array2.length; ++i) {
                System.out.println("good slot = " + unsignedInt32Array2[i].toString());
                pIIOSlotDataBean = this.getIoSlot(hashtable, unsignedInt32Array2[i].toString());
                String string5 = pIIOSlotDataBean.getBusID();
                Integer n7 = (Integer)hashtable4.get(string5);
                if (n7 != null) {
                    int n8 = n7 + 1;
                    hashtable4.put(string5, new Integer(n8));
                    System.out.println("PHB already varied OFF skip it --------------------");
                    System.out.println("Number of slots (so far) under this PHB: " + n8);
                    blArray[i] = true;
                    continue;
                }
                if (!this.busHasActiveSlots(string5, this.lparId(this), hashtable)) {
                    PIIOBusDataBean pIIOBusDataBean = this.getIoBus(hashtable, string5);
                    string2 = pIIOBusDataBean.getBusDrcName();
                    System.out.println("Call to vary off PHB. phb DRC name = " + string2);
                    System.out.println("ON paritition " + this.lparId(this));
                    try {
                        Hashtable hashtable6 = this.varyOnOffPHB(string2, n, s, "r", this.lparId(this), bl2);
                        boolean bl9 = (Boolean)hashtable6.get("IsError");
                        if (bl9) {
                            blArray[i] = false;
                            bl4 = true;
                            string3 = string3 + (String)hashtable6.get("InfoMsg");
                            continue;
                        }
                        System.out.println("REMOVING PHB " + string5);
                        hashtable4.put(string5, new Integer(1));
                        System.out.println(" SUCCESSFULLY removed PHB " + string2);
                    }
                    catch (Throwable throwable) {
                        blArray[i] = false;
                        bl4 = true;
                        string3 = string3 + throwable.getMessage();
                    }
                    continue;
                }
                blArray[i] = true;
            }
        }
        if (bl4 && this.isRPA(pIHscDlparCIMClient) && !bl2) {
            if (hashtable2.size() == 0) {
                System.out.println(" got trimmed totally --- ");
                System.out.println(" varying off all PHBs added to DEST ----------------");
                if (hashtable3.isEmpty()) {
                    System.out.println(" NO PHBs added to DEST - no vary off ----------------");
                }
            } else {
                hashtable2 = this.slotInfoTrim(hashtable2, blArray, true);
                System.out.println("PHB rollback: failed slots = " + hashtable2.size());
                UnsignedInt32[] unsignedInt32Array3 = (UnsignedInt32[])hashtable2.get("DRCIndex");
                blArray = new boolean[unsignedInt32Array3.length];
                hashtable = this.getIoData(pIHscDlparCIMClient);
                for (int i = 0; i < unsignedInt32Array3.length; ++i) {
                    System.out.println("bad slot = " + unsignedInt32Array3[i].toString());
                    pIIOSlotDataBean = this.getIoSlot(hashtable, unsignedInt32Array3[i].toString());
                    System.out.println("PHB rollback: failed slots = " + n3);
                    String string6 = pIIOSlotDataBean.getBusID();
                    Integer n9 = (Integer)hashtable3.get(string6);
                    if (n9 != null) {
                        int n10 = n9 - 1;
                        hashtable3.put(string6, new Integer(n10));
                        if (n10 != 0) {
                            System.out.println("STILL ADDED SLOTS UNDER THIS PHB -----");
                            System.out.println("numSlotsUnderPHB = " + n10);
                            continue;
                        }
                    } else {
                        System.out.println("in moveIo: no PHB ever added for slot -----");
                    }
                    if (this.busHasActiveSlots(pIIOSlotDataBean.getBusID(), this.lparId(pIHscDlparCIMClient), hashtable)) continue;
                    PIIOBusDataBean pIIOBusDataBean = this.getIoBus(hashtable, string6);
                    string2 = pIIOBusDataBean.getBusDrcName();
                    System.out.println("must roll back phb : " + string2);
                    try {
                        Hashtable hashtable7 = this.varyOnOffPHB(string2, n, s, "r", this.lparId(pIHscDlparCIMClient), bl2);
                        boolean bl10 = (Boolean)hashtable7.get("IsError");
                        if (!bl10) continue;
                        string3 = string3 + (String)hashtable7.get("InfoMsg");
                        continue;
                    }
                    catch (Throwable throwable) {
                        string3 = string3 + throwable.getMessage();
                    }
                }
            }
        }
        if (bl4) {
            throw new PIHscClientException("2930", "HSCCIMExceptionBundle", "2930", new String[]{string3});
        }
        return n3;
    }

    private void doBatchOperation(PIHscDlparCIMClient pIHscDlparCIMClient, PIHscDlparCIMClient pIHscDlparCIMClient2, int n, int n2, int n3, String string, String string2, boolean bl) throws PIHscClientException {
        this.startLparBatchMode(2);
        if (string == null) {
            try {
                this.doDlparMemOperation("removeMem", n - n3, pIHscDlparCIMClient);
            }
            catch (PIHscClientException pIHscClientException) {
                HSCLogUtils.clientLog(pIHscClientException, HSCLogUtils._DLPARClassLogInfo);
                System.out.println("moveMem() -> Remove mem from source");
                throw pIHscClientException;
            }
            Object var9_10 = null;
            try {
                this.doDlparMemOperation("addMem", n2 + n3, pIHscDlparCIMClient2);
            }
            catch (PIHscClientException pIHscClientException) {
                HSCLogUtils.clientLog(pIHscClientException, HSCLogUtils._DLPARClassLogInfo);
                System.out.println("moveMem() -> Add mem to destination ");
                throw pIHscClientException;
            }
        }
        try {
            this.doDlparMemOperation("removeMem", n2, pIHscDlparCIMClient2);
        }
        catch (PIHscClientException pIHscClientException) {
            HSCLogUtils.clientLog(pIHscClientException, HSCLogUtils._DLPARClassLogInfo);
            System.out.println("moveMem() -> Remove mem from dest");
            throw pIHscClientException;
        }
        try {
            this.doDlparMemOperation("addMem", n, pIHscDlparCIMClient);
        }
        catch (PIHscClientException pIHscClientException) {
            HSCLogUtils.clientLog(pIHscClientException, HSCLogUtils._DLPARClassLogInfo);
            System.out.println("moveMem() -> Add mem to destination ");
            throw pIHscClientException;
        }
        this.commitLparBatch();
    }

    public boolean smpPartition() throws PIHscClientException {
        String string = null;
        try {
            CIMValue cIMValue = PIHscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, "PartitionType");
            if (cIMValue == null) {
                return false;
            }
            string = (String)cIMValue.getValue();
            short s = Short.parseShort(string);
            return s == 0;
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public boolean affinityPartition() throws PIHscClientException {
        String string = null;
        try {
            CIMValue cIMValue = PIHscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, "PartitionType");
            if (cIMValue == null) {
                return false;
            }
            string = (String)cIMValue.getValue();
            short s = Short.parseShort(string);
            return s == 2 || s == 3;
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public boolean dlparEnabled(String string) throws PIHscClientException {
        return true;
    }

    private void startLparBatchMode(int n) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMProperty("desiredBatchSize", new CIMValue((Object)new UnsignedInt16(n))));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "startLparBatchMode", vector, vector2);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    private void commitLparBatch() throws PIHscClientException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "commitLparBatch", vector, vector2);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    private int doRMCoperation(String string, Vector vector) throws PIHscClientException {
        Vector vector2 = new Vector();
        int n = -1;
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, string, vector, vector2);
            CIMProperty cIMProperty = (CIMProperty)vector2.elementAt(0);
            n = ((UnsignedInt16)cIMProperty.getValue().getValue()).intValue();
            return n;
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    private void doDlparMemOperation(String string, int n, PIHscDlparCIMClient pIHscDlparCIMClient) throws PIHscClientException {
    }

    private void doDlparMemOperation(String string, Vector vector) throws PIHscClientException {
        String string2 = null;
        Vector vector2 = new Vector();
        boolean bl = false;
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, string, vector, vector2);
            PIHscDlparCIMClient.debug("after invoke : " + vector2.toString());
            if (vector2.size() > 0) {
                if ("addMem".equals(string)) {
                    string2 = (String)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                    if (!string2.equals("0")) {
                        bl = true;
                    }
                } else if ("removeMem".equals(string)) {
                    string2 = (String)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                    if (!string2.equals("0")) {
                        bl = true;
                    }
                } else {
                    string2 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                    if (!string2.equals("0")) {
                        bl = true;
                    }
                    if (vector2.size() == 2 && !(string2 = (String)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).equals("0")) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                PIHscClientException pIHscClientException = null;
                String[] stringArray = new String[]{string2};
                pIHscClientException = string.equals("addMem") ? new PIHscClientException("2931", "HSCCIMExceptionBundle", "2931", stringArray) : (string.equals("removeMem") ? new PIHscClientException("2932", "HSCCIMExceptionBundle", "2932", stringArray) : new PIHscClientException("2933", "HSCCIMExceptionBundle", "2933", stringArray));
                this.mOutputStrHandler.handleOutputStr(pIHscClientException.getMessage());
                PIHscDlparCIMClient.debug(string + "." + pIHscClientException.getMessage());
                throw pIHscClientException;
            }
        }
        catch (CIMException cIMException) {
            PIHscDlparCIMClient.debug("dlpar mem exception: " + cIMException.toString());
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = null;
            PIHscDlparCIMClient.debug("DLPAR Mem exception = " + cIMException.toString());
            PIHscDlparCIMClient.debug("outParams : " + vector2.toString());
            if (vector2.size() > 0) {
                PIHscDlparCIMClient.debug("outParams : " + vector2.size());
                String[] stringArray = new String[1];
                if ("addMem".equals(string)) {
                    string2 = (String)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                    if (!string2.equals("0")) {
                        stringArray[0] = string2;
                        pIHscClientException = new PIHscClientException("2932", "HSCCIMExceptionBundle", "2932", stringArray);
                    }
                } else if ("removeMem".equals(string)) {
                    string2 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                    if (!string2.equals("0")) {
                        stringArray[0] = string2;
                        pIHscClientException = new PIHscClientException("2932", "HSCCIMExceptionBundle", "2932", stringArray);
                    }
                } else {
                    String string3 = "";
                    if (vector2.size() == 2) {
                        string2 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                        if (!string2.equals("0")) {
                            string3 = string3 + string2 + "\n";
                        }
                        if (!(string2 = (String)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).equals("0")) {
                            string3 = string3 + string2;
                        }
                    } else {
                        string2 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                        if (!string2.equals("0")) {
                            string3 = string2;
                        }
                    }
                    if (string3.trim().length() > 0) {
                        stringArray[0] = string3;
                        pIHscClientException = new PIHscClientException("2933", "HSCCIMExceptionBundle", "2933", stringArray);
                    }
                }
                this.mOutputStrHandler.handleOutputStr(pIHscClientException.getMessage());
                throw pIHscClientException;
            }
            PIHscClientException pIHscClientException2 = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException2 == null) {
                pIHscClientException2 = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            this.mOutputStrHandler.handleOutputStr(pIHscClientException2.getMessage());
            throw pIHscClientException2;
        }
    }

    private Vector doDlparIoOperation(String string, Hashtable hashtable, PIHscDlparCIMClient pIHscDlparCIMClient, int n, short s, boolean bl) throws PIHscClientException {
        System.err.println(this.getClass() + ".doDlparIoOperation(): " + string);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        int n2 = 0;
        boolean bl2 = false;
        UnsignedInt32[] unsignedInt32Array = (UnsignedInt32[])hashtable.get("DRCIndex");
        UnsignedInt16[] unsignedInt16Array = (UnsignedInt16[])hashtable.get("poolID");
        UnsignedInt16[] unsignedInt16Array2 = null;
        String[] stringArray = (String[])hashtable.get("PhyLocCode");
        if (string.equals("addIo")) {
            bl2 = true;
            unsignedInt16Array2 = (UnsignedInt16[])hashtable.get("SrcLparID");
        }
        if (pIHscDlparCIMClient == this) {
            n2 = this.getPartitionSlotId(this.mIntName);
        } else if (pIHscDlparCIMClient != null) {
            n2 = pIHscDlparCIMClient.getPartitionSlotId(pIHscDlparCIMClient.mIntName);
        }
        if (pIHscDlparCIMClient == null) {
            n2 = -1;
        }
        vector.addElement(new CIMProperty("DestinationLparID", new CIMValue((Object)new UnsignedInt16(n2))));
        if (bl2) {
            vector.addElement(new CIMProperty("SrcLparID", new CIMValue((Object)unsignedInt16Array2, new CIMDataType(23))));
        }
        vector.addElement(new CIMProperty("DRCIndex", new CIMValue((Object)unsignedInt32Array, new CIMDataType(25))));
        vector.addElement(new CIMProperty("PhyLocCode", new CIMValue((Object)stringArray, new CIMDataType(29))));
        vector.addElement(new CIMProperty("poolID", new CIMValue((Object)unsignedInt16Array, new CIMDataType(23))));
        vector.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n))));
        vector.addElement(new CIMProperty("detailLevel", new CIMValue((Object)new UnsignedInt16((int)s))));
        vector.addElement(new CIMProperty("clearFlag", new CIMValue((Object)new UnsignedInt8(0))));
        vector.addElement(new CIMProperty("noRMCConnection", new CIMValue((Object)new Boolean(bl))));
        System.out.println("client side : inParams = " + vector);
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, string, vector, vector2);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "HSCCIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            pIHscClientException.printStackTrace();
            throw pIHscClientException;
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
            System.out.println("exception invoking CIMMethod in doDlparCpuOperation ======= " + throwable);
            throwable.printStackTrace();
            throw new PIHscClientException(throwable.getMessage());
        }
        Object e = vector2.elementAt(0);
        Vector vector3 = null;
        vector3 = e instanceof CIMValue ? (Vector)((CIMValue)e).getValue() : (Vector)((CIMProperty)e).getValue().getValue();
        boolean[] blArray = new boolean[vector3.size()];
        Hashtable<String, UnsignedInt32[]> hashtable2 = new Hashtable<String, UnsignedInt32[]>();
        hashtable2.put("DRCIndex", unsignedInt32Array);
        String string2 = this.getSlotOutMessage(vector3, hashtable2, blArray);
        if (string2 != null) {
            Vector<Object> vector4 = new Vector<Object>();
            vector4.addElement(string2);
            vector4.addElement(blArray);
            return vector4;
        }
        return null;
    }

    public String getPartitionType() throws PIHscClientException {
        this.debug1("in getPartitionType()");
        short s = ((UnsignedInt8)this.m_lparInst.getProperty("DefinitionState").getValue().getValue()).shortValue();
        this.debug1("defState = " + s);
        if (130 == s || 129 == s) {
            this.debug1("OS400 partition");
            return "OS400_PARTITION";
        }
        this.debug1("RPA partition");
        return "RPA_PARTITION";
    }

    private void varyOffMemory(int n, int n2, int n3) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMProperty("LPARSlotID", new CIMValue((Object)new UnsignedInt16(n2))));
        vector.addElement(new CIMProperty("memRegion", new CIMValue((Object)new UnsignedInt32((long)n))));
        vector.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n3))));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "varyOffMemory", vector, vector2);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    private void varyOnMemory(int n, int n2, int n3) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMProperty("LPARSlotID", new CIMValue((Object)new UnsignedInt16(n2))));
        vector.addElement(new CIMProperty("memRegion", new CIMValue((Object)new UnsignedInt32((long)n))));
        vector.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n3))));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "varyOnMemory", vector, vector2);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public PIHSCRMCClient getRMCClient() {
        return this.mRMCClient;
    }

    private Vector getInputVector(String string) {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        UnsignedInt16 unsignedInt16 = new UnsignedInt16((int)this.getPartitionSlotId(string));
        CIMValue cIMValue = new CIMValue((Object)unsignedInt16, new CIMDataType(3));
        vector.addElement(new CIMProperty("LPARSlotID", cIMValue));
        return vector;
    }

    private short getPartitionSlotId(String string) {
        String string2 = null;
        string2 = string.indexOf("*") == -1 ? string : string.substring(0, string.indexOf("*"));
        return Short.parseShort(string2);
    }

    private Integer getIntFromVector(Vector vector, int n) {
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)vector.elementAt(n);
        return new Integer(unsignedInt32.intValue());
    }

    public int addCpu(int n, long l, int n2, int n3, int n4, short s, boolean bl, short s2) throws PIHscClientException {
        boolean bl2 = false;
        Hashtable hashtable = new Hashtable();
        CIMInstance cIMInstance = null;
        int n5 = 0;
        int n6 = this.NO_PROCS;
        long l2 = 0L;
        long l3 = this.NO_PROC_UNITS;
        int n7 = 0;
        System.out.println("in addCpu /////////////////////////////////////");
        System.out.println("numProcs = " + n);
        System.out.println("numProcUnits = " + l);
        System.out.println("interactive = " + n2);
        System.out.println("uncappedWeight = " + n3);
        System.out.println("Timeout = " + n4);
        System.out.println("DetailLevel = " + s);
        System.out.println("sharingMode = " + s2);
        String string = this.getMessage("INFO_ADD_HMC", INFO_ADD_HMC, new String[]{INFO_PROCESSING_RES});
        try {
            System.out.println("Starting addCpu call");
            if (s2 != this.NO_SHARING_MODE) {
                System.out.println("addCpu: CALLING SET OPERATION to SET sharing mode =================");
                if (s2 == this.SHARING_MODE_CAPPED) {
                    System.out.println("going to CAPPED - setting uncappedWeight to 0 ===== ");
                    n3 = 0;
                }
                this.setCpu(s2, n3, n2, n4, bl);
                if (n == this.NO_PROCS && l == this.NO_PROC_UNITS) {
                    System.out.println("exit addCpu: set operation successful");
                    return 1;
                }
                s2 = this.NO_SHARING_MODE;
                n3 = this.NO_UNCAPPED_WEIGHT;
                n2 = this.NO_INTERACTIVE;
            }
            if (this.isOS400(this)) {
                cIMInstance = this.getLparInst();
                n7 = ((UnsignedInt8)cIMInstance.getProperty("CurProcMode").getValue().getValue()).intValue();
                if (n7 == 255) {
                    n5 = ((UnsignedInt16)cIMInstance.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                } else {
                    if (n != this.NO_PROCS) {
                        n5 = ((UnsignedInt16)cIMInstance.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                    }
                    if (l != this.NO_PROC_UNITS) {
                        l2 = ((UnsignedInt32)cIMInstance.getProperty("CurAllocProcUnits").getValue().getValue()).intValue();
                    }
                }
            }
            try {
                hashtable = this.doDlparCpuOperationAdd("addCpu", n, l, s2, n3, n2, n4, s, bl, this);
                System.out.println("CLIENT - well returned from CPU RPA");
                System.out.println("results = " + hashtable);
                bl2 = (Boolean)hashtable.get("IsError");
                if (bl2) {
                    string = string + (String)hashtable.get("InfoMsg");
                    System.out.println("Call to doDlparCpuOperationAdd returned some error: \n" + string);
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                System.out.println("Hit exception in doDlparCpuOperationAdd----------------");
                if (!(throwable instanceof PIHscClientException)) {
                    throw new PIHscClientException(throwable.getMessage());
                }
                throw (PIHscClientException)throwable;
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
            if (!(throwable instanceof PIHscClientException)) {
                string = string + throwable.getMessage();
                throw new PIHscClientException(string);
            }
            throw (PIHscClientException)throwable;
        }
        if (bl2) {
            throw new PIHscClientException("294E", "HSCCIMExceptionBundle", "294E", new String[]{string});
        }
        if (n == this.NO_PROCS) {
            if (l == this.NO_PROC_UNITS) {
                return 1;
            }
            return (int)l;
        }
        return n;
    }

    public int removeCpu(int n, long l, int n2, int n3, int n4, short s, boolean bl, short s2) throws PIHscClientException {
        String string;
        boolean bl2;
        block52: {
            System.out.println("in removeCpu /////////////////////////////////////");
            System.out.println("numProcs = " + n);
            System.out.println("numProcUnits = " + l);
            System.out.println("interactive = " + n2);
            System.out.println("uncappedWeight = " + n3);
            System.out.println("timeout = " + n4);
            System.out.println("detailLevel = " + s);
            System.out.println("sharingMode = " + s2);
            System.out.println("Starting RMC removeCpu call");
            boolean bl3 = false;
            int n5 = 0;
            Hashtable hashtable = new Hashtable();
            Object var13_12 = null;
            bl2 = false;
            CIMInstance cIMInstance = null;
            int n6 = this.NO_PROCS;
            int n7 = this.NO_PROCS;
            long l2 = this.NO_PROC_UNITS;
            long l3 = this.NO_PROC_UNITS;
            int n8 = 0;
            int n9 = this.NO_UNCAPPED_WEIGHT;
            int n10 = 0;
            int n11 = 0;
            boolean bl4 = false;
            string = this.getMessage("INFO_REMOVE_HMC", INFO_REMOVE_HMC, new String[]{INFO_PROCESSING_RES});
            try {
                CIMValue cIMValue;
                if (s2 != this.NO_SHARING_MODE) {
                    System.out.println("removeCpu: CALLING SET OPERATION to SET sharing mode =================");
                    if (s2 == this.SHARING_MODE_CAPPED) {
                        System.out.println("going to CAPPED - setting uncappedWeight to 0 ===== ");
                        n3 = 0;
                    }
                    this.setCpu(s2, n3, n2, n4, bl);
                    if (n == this.NO_PROCS && l == this.NO_PROC_UNITS) {
                        System.out.println("exit removeCpu: set operation successful");
                        return 1;
                    }
                    s2 = this.NO_SHARING_MODE;
                    n3 = this.NO_UNCAPPED_WEIGHT;
                    n2 = this.NO_INTERACTIVE;
                }
                if ((cIMValue = (cIMInstance = this.getLparInst()).getProperty("DLPARCapabilities").getValue()) != null && (n11 = ((UnsignedInt32)cIMValue.getValue()).intValue()) > 15) {
                    bl4 = true;
                }
                System.out.println("dlparCapabilities = " + n11);
                n8 = ((UnsignedInt8)cIMInstance.getProperty("CurProcMode").getValue().getValue()).intValue();
                System.out.println("in removeCpu ----- proc type = " + n8);
                if (n8 == 255) {
                    n6 = ((UnsignedInt16)cIMInstance.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                } else {
                    if (n != this.NO_PROCS) {
                        n6 = ((UnsignedInt16)cIMInstance.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                    }
                    if (l != this.NO_PROC_UNITS) {
                        l2 = ((UnsignedInt32)cIMInstance.getProperty("CurAllocProcUnits").getValue().getValue()).intValue();
                    }
                    if (n3 != this.NO_UNCAPPED_WEIGHT) {
                        n9 = ((UnsignedInt8)cIMInstance.getProperty("CurUncappedWeight").getValue().getValue()).intValue();
                    }
                }
                n10 = this.isOS400(this) ? ((UnsignedInt16)cIMInstance.getProperty("CurAllocInteractivePerf").getValue().getValue()).intValue() : this.NO_INTERACTIVE;
                PIHSCCECCIMClient pIHSCCECCIMClient = (PIHSCCECCIMClient)this.mParentObject;
                PICECDataBean pICECDataBean = pIHSCCECCIMClient.getCECDataBean(new String[]{"mfg_default_config"});
                System.out.println("The flag for MGMode is : " + pICECDataBean.isMfgDefaultConfig());
                if (!pICECDataBean.isMfgDefaultConfig()) {
                    try {
                        hashtable = this.doDlparCpuOperation("CPULPARTask", n, l, s2, n3, n2, n4, s, bl, null);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                        System.out.println("removeCpu: got exception trying to set pending.... " + throwable);
                        if (!(throwable instanceof PIHscClientException)) {
                            string = string + throwable.getMessage();
                            throw new PIHscClientException(string);
                        }
                        throw (PIHscClientException)throwable;
                    }
                }
                System.out.println("Finished PHYP removeCpu call");
                if (this.isOS400(this)) {
                    if (n8 == 255) {
                        n7 = n6 - n;
                        System.out.println("in removeCpu: removing dedicated numProcs = " + n + "  currProcs = " + n6);
                    } else {
                        if (n != this.NO_PROCS) {
                            n7 = n6 - n;
                        }
                        if (l != this.NO_PROC_UNITS) {
                            l3 = l2 - l;
                            System.out.println("in removeCpu: removing shared numProcUnits = " + l + "  currProcUnits = " + l2);
                        }
                    }
                    System.out.println("STARTING the VARY OFF of the PROCESSING------------------------------");
                    short s3 = this.getPartitionSlotId(this.mIntName);
                    try {
                        this.varyOnOffProcessing(s3, n7, l3, n3, n2, n4);
                    }
                    catch (Throwable throwable) {
                        System.out.println("Caught exception while trying to VARY OFF processing resources: " + throwable);
                        hashtable = this.doDlparCpuOperation("CPULPARTask", n6, l2, s2, n9, n10, n4, s, bl, this);
                        if (!(throwable instanceof PIHscClientException)) {
                            throw new PIHscClientException(throwable.getMessage());
                        }
                        throw (PIHscClientException)throwable;
                    }
                    System.out.println("VARIED OFF the PROCESSING------------------------------");
                    break block52;
                }
                if (bl) break block52;
                System.out.println("Starting RMC removeCpu call");
                string = string + this.getMessage("INFO_REMOVE_RPA", INFO_REMOVE_RPA, new String[]{INFO_PROCESSING_RES});
                if (n != this.NO_PROCS) {
                    try {
                        if (bl4) {
                            System.out.println("DLPAR Remove: src partition is multi-cpu capable");
                            this.mRMCClient.rmcDLPARCpuOp(n, this.NO_PROC_UNITS, this.NO_UNCAPPED_WEIGHT, n4, s, "r");
                        } else {
                            System.out.println("DLPAR Remove: src partition is NOT multi-cpu capable");
                            for (int i = 0; i < n; ++i) {
                                this.mRMCClient.rmcDLPARCpuOp(1, this.NO_PROC_UNITS, this.NO_UNCAPPED_WEIGHT, n4, s, "r");
                            }
                        }
                        System.out.println("Finished RMC call to REMOVE Procs");
                    }
                    catch (HSCRMCException hSCRMCException) {
                        System.out.println("RMC REMOVE procs call failed: number of successes = " + hSCRMCException.getNumberOfSuccesses());
                        n5 = hSCRMCException.getNumberOfSuccesses();
                        string = string + this.getMessage(hSCRMCException);
                        bl2 = true;
                        if (n8 == 255) {
                            try {
                                hashtable = this.doDlparCpuOperation("CPULPARTask", n6 - n5, this.NO_PROC_UNITS, s2, this.NO_UNCAPPED_WEIGHT, this.NO_INTERACTIVE, n4, s, bl, this);
                            }
                            catch (Throwable throwable) {
                                System.out.println("got an exception trying to reset pending\n");
                                string = string + this.getMessage(throwable);
                            }
                            throw new PIHscClientException("294F", "HSCCIMExceptionBundle", "294F", new String[]{string});
                        }
                        try {
                            hashtable = this.doDlparCpuOperation("CPULPARTask", n6, l2, s2, n9, n10, n4, s, bl, this);
                        }
                        catch (Throwable throwable) {
                            System.out.println("got an exception trying to reset pending\n");
                            string = string + this.getMessage(throwable);
                        }
                        throw new PIHscClientException("294F", "HSCCIMExceptionBundle", "294F", new String[]{string});
                    }
                }
                if (n8 != 255 && l != this.NO_PROC_UNITS) {
                    try {
                        this.mRMCClient.rmcDLPARCpuOp(this.NO_PROCS, l, this.NO_UNCAPPED_WEIGHT, n4, s, "r");
                        System.out.println("Finished RMC call to REMOVE Proc Units");
                    }
                    catch (HSCRMCException hSCRMCException) {
                        System.out.println("removeCpu: RMC REMOVE procs call failed: number of successes = " + hSCRMCException.getNumberOfSuccesses());
                        n5 = hSCRMCException.getNumberOfSuccesses();
                        string = string + this.getMessage(hSCRMCException);
                        bl2 = true;
                        try {
                            hashtable = this.doDlparCpuOperation("CPULPARTask", n6, l2, s2, n9, n10, n4, s, bl, this);
                            if (n != this.NO_PROCS) {
                                if (bl4) {
                                    System.out.println("DLPAR Remove RECOVERY: src partition is multi-cpu capable");
                                    this.mRMCClient.rmcDLPARCpuOp(n, this.NO_PROC_UNITS, this.NO_UNCAPPED_WEIGHT, n4, s, "a");
                                } else {
                                    System.out.println("DLPAR Remove RECOVERY: src partition is NOT multi-cpu capable");
                                    for (int i = 0; i < n; ++i) {
                                        this.mRMCClient.rmcDLPARCpuOp(1, this.NO_PROC_UNITS, this.NO_UNCAPPED_WEIGHT, n4, s, "a");
                                    }
                                }
                                System.out.println("Finished RMC call to REMOVE Procs");
                            }
                        }
                        catch (Throwable throwable) {
                            System.out.println("got an exception trying to reset pending\n");
                            string = string + this.getMessage(throwable);
                        }
                        throw new PIHscClientException("294F", "HSCCIMExceptionBundle", "294F", new String[]{string});
                    }
                }
                if (n3 == this.NO_UNCAPPED_WEIGHT) break block52;
                try {
                    if (n3 < n9) {
                        this.mRMCClient.rmcDLPARCpuOp(this.NO_PROCS, this.NO_PROC_UNITS, (short)(n9 - n3), n4, s, "r");
                        System.out.println("Finished RMC call to REMOVE uncapped weight");
                    } else if (n3 > n9) {
                        this.mRMCClient.rmcDLPARCpuOp(this.NO_PROCS, this.NO_PROC_UNITS, (short)(n3 - n9), n4, s, "a");
                        System.out.println("Finished RMC call to REMOVE uncapped weight");
                    }
                }
                catch (HSCRMCException hSCRMCException) {
                    HSCLogUtils.clientLog(hSCRMCException, HSCLogUtils._DLPARClassLogInfo);
                    System.out.println("RMC REMOVE: uncapped weight call failed: number of successes = " + hSCRMCException.getNumberOfSuccesses());
                    n5 = hSCRMCException.getNumberOfSuccesses();
                    string = string + this.getMessage(hSCRMCException);
                    bl2 = true;
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                if (!(throwable instanceof PIHscClientException)) {
                    string = string + throwable.getMessage();
                    throw new PIHscClientException(string);
                }
                throw (PIHscClientException)throwable;
            }
        }
        if (bl2) {
            throw new PIHscClientException("294F", "HSCCIMExceptionBundle", "294F", new String[]{string});
        }
        if (n == this.NO_PROCS) {
            if (l == this.NO_PROC_UNITS) {
                return 1;
            }
            return (int)l;
        }
        return n;
    }

    public int moveCpu(int n, long l, String string, boolean bl, int n2, int n3, int n4, short s, boolean bl2, short s2) throws PIHscClientException {
        String string2;
        boolean bl3;
        block87: {
            bl3 = false;
            Hashtable hashtable = new Hashtable();
            PIHscDlparCIMClient pIHscDlparCIMClient = null;
            Object var16_14 = null;
            Object var17_15 = null;
            System.out.println("in moveCpu /////////////////////////////////////");
            System.out.println("numProcs = " + n);
            System.out.println("numProcUnits = " + l);
            System.out.println("destLpar = " + string);
            System.out.println("interactive = " + n2);
            System.out.println("uncappedWeight = " + n3);
            System.out.println("Timeout = " + n4);
            System.out.println("DetailLevel = " + s);
            System.out.println("sharingMode = " + s2);
            int n5 = 0;
            int n6 = 0;
            int n7 = this.NO_PROCS;
            long l2 = 0L;
            long l3 = this.NO_PROC_UNITS;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            int n12 = 0;
            int n13 = 0;
            int n14 = this.NO_PROCS;
            long l4 = 0L;
            long l5 = this.NO_PROC_UNITS;
            int n15 = 0;
            int n16 = this.NO_INTERACTIVE;
            PIHSCRMCClientFactory pIHSCRMCClientFactory = null;
            PIHSCRMCClient pIHSCRMCClient = null;
            boolean bl6 = false;
            int n17 = 0;
            string2 = this.getMessage("INFO_REMOVE_HMC", INFO_REMOVE_HMC, new String[]{INFO_PROCESSING_RES});
            try {
                CIMValue cIMValue;
                try {
                    pIHscDlparCIMClient = PIHscDlparCIMClient.createInstance(this.mHostName, this.mParentObject.getIntName(), string.trim(), bl, "root/ibmhscS1_0");
                    if (!this.isOS400(pIHscDlparCIMClient)) {
                        pIHSCRMCClientFactory = PIHSCRMCClientFactory.getInstance(this.mCecIntName);
                        pIHSCRMCClient = pIHSCRMCClientFactory.createRMCClient(pIHscDlparCIMClient.mIntName);
                    }
                }
                catch (PIHscClientException pIHscClientException) {
                    HSCLogUtils.clientLog(pIHscClientException, HSCLogUtils._DLPARClassLogInfo);
                    System.out.println(" failed to create dest Client ==================");
                    pIHscClientException.printStackTrace();
                    throw pIHscClientException;
                }
                System.out.println("Starting PHYP moveCpu call");
                if (s2 != this.NO_SHARING_MODE) {
                    System.out.println("moveCpu: CALLING SET OPERATION to SET sharing mode =================");
                    if (s2 == this.SHARING_MODE_CAPPED) {
                        System.out.println("going to CAPPED - setting uncappedWeight to 0 ===== ");
                        n3 = 0;
                    }
                    this.setCpu(s2, n3, n2, n4, bl2);
                    if (n == this.NO_PROCS && l == this.NO_PROC_UNITS) {
                        System.out.println("exit moveCpu: set operation successful");
                        return 1;
                    }
                    s2 = this.NO_SHARING_MODE;
                    n3 = this.NO_UNCAPPED_WEIGHT;
                    n2 = this.NO_INTERACTIVE;
                }
                hashtable = this.doDlparCpuOperation("CPULPARTask", n, l, s2, n3, n2, n4, s, bl2, pIHscDlparCIMClient);
                System.out.println("Finished PHYP call move cpu");
                CIMInstance cIMInstance = this.getLparInst();
                n5 = ((UnsignedInt8)cIMInstance.getProperty("CurProcMode").getValue().getValue()).intValue();
                CIMValue cIMValue2 = cIMInstance.getProperty("DLPARCapabilities").getValue();
                if (cIMValue2 != null && (n10 = ((UnsignedInt32)cIMValue2.getValue()).intValue()) > 15) {
                    bl4 = true;
                }
                System.out.println("srcDlparCapabilities = " + n10);
                n6 = ((UnsignedInt16)cIMInstance.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                System.out.println("moveCPU: currProcs = " + n6);
                if (n5 != 255) {
                    l2 = ((UnsignedInt32)cIMInstance.getProperty("CurAllocProcUnits").getValue().getValue()).intValue();
                    System.out.println("moveCPU: currProcUnits = " + l2);
                    n8 = ((UnsignedInt8)cIMInstance.getProperty("CurUncappedWeight").getValue().getValue()).intValue();
                    System.out.println("moveCPU: currUncappedWeight = " + n8);
                }
                n9 = this.isOS400(this) ? ((UnsignedInt16)cIMInstance.getProperty("CurAllocInteractivePerf").getValue().getValue()).intValue() : this.NO_INTERACTIVE;
                CIMInstance cIMInstance2 = pIHscDlparCIMClient.getLparInst();
                n12 = ((UnsignedInt8)cIMInstance2.getProperty("CurProcMode").getValue().getValue()).intValue();
                System.out.println("moveCPU: destProcType = " + n12);
                n13 = ((UnsignedInt16)cIMInstance2.getProperty("CurAllocProcs").getValue().getValue()).intValue();
                System.out.println("moveCPU: destCurrProcs = " + n13);
                if (n12 != 255) {
                    l4 = ((UnsignedInt32)cIMInstance2.getProperty("CurAllocProcUnits").getValue().getValue()).intValue();
                    System.out.println("moveCPU: destCurrProcUnits = " + l4);
                    n15 = ((UnsignedInt8)cIMInstance2.getProperty("CurUncappedWeight").getValue().getValue()).intValue();
                    System.out.println("moveCPU: destCurrUncappedWeight = " + n15);
                }
                if ((cIMValue = cIMInstance2.getProperty("DLPARCapabilities").getValue()) != null && (n11 = ((UnsignedInt32)cIMValue.getValue()).intValue()) > 15) {
                    bl5 = true;
                }
                System.out.println("destDlparCapabilities = " + n11);
                if (this.isOS400(pIHscDlparCIMClient)) {
                    System.out.println("in moveCpu:  DESTINATION PARTITION is OS400 ;;;;;;;;;;;;;");
                    if (n12 == 255) {
                        if (n5 == 255) {
                            n14 = n13 + n;
                            System.out.println("in moveCpu - moving dedicated to dedicated = " + n + "  currProcs = " + n13);
                        } else {
                            if (l % 100L != 0L) {
                                System.out.println("in moveCpu - MOVING SHARED TO DEDICATED - NOT A WHOLE PROC FAIL");
                                return -1;
                            }
                            n14 = n13 + (int)(l / 100L);
                        }
                    } else if (n5 == 255) {
                        l5 = l4 + (long)(n * 100);
                    } else {
                        if (n != this.NO_PROCS) {
                            n14 = n13 + n;
                            System.out.println("in moveCpu - add shared numProcs = " + n + "  destCurrProcs = " + n13);
                        }
                        if (l != this.NO_PROC_UNITS) {
                            l5 = l4 + l;
                            System.out.println("in moveCpu - add shared numProcUnits = " + l + "  currProcUnits = " + l4);
                        }
                    }
                    n16 = ((UnsignedInt16)cIMInstance2.getProperty("CurAllocInteractivePerf").getValue().getValue()).intValue();
                } else {
                    System.out.println("in moveCpu:  DESTINATION PARTITION is RPA ;;;;;;;;;;;;;");
                    if (n12 == 255) {
                        if (n5 == 255) {
                            n14 = n;
                            System.out.println("in moveCpu RPA - moving dedicated to dedicated = " + n + "  dest Procs = " + n14);
                        } else {
                            if (l % 100L != 0L) {
                                System.out.println("MOVING SHARED TO DEDICATED - NOT A WHOLE PROC FAIL");
                                return -1;
                            }
                            n14 = (int)(l / 100L);
                        }
                    } else if (n5 == 255) {
                        l5 = n * 100;
                    } else {
                        System.out.println("in moveCpu RPA - moving shared to shared: destNProcs = " + n14 + "  destNProcUnits = " + l5);
                        n14 = n;
                        l5 = l;
                    }
                }
                if (this.isOS400(this)) {
                    if (n5 == 255) {
                        n7 = n6 - n;
                        System.out.println("in removeCpu: removing dedicated numProcs = " + n + "  currProcs = " + n6);
                    } else {
                        if (n != this.NO_PROCS) {
                            n7 = n6 - n;
                        }
                        if (l != this.NO_PROC_UNITS) {
                            l3 = l2 - l;
                            System.out.println("in removeCpu: removing shared numProcUnits = " + l + "  currProcUnits = " + l2);
                        }
                    }
                    System.out.println("DLPAR MOVE: STARTING VARY OFF the PROCESSING------------------------------");
                    short s3 = this.getPartitionSlotId(this.mIntName);
                    try {
                        this.varyOnOffProcessing(s3, n7, l3, n3, n2, n4);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                        System.out.println("Caught exception while trying to VARY OFF processing resources: " + throwable);
                        string2 = string2 + this.getMessage(throwable);
                        try {
                            hashtable = pIHscDlparCIMClient.doDlparCpuOperation("CPULPARTask", n13, l4, s2, n15, n16, n4, s, bl2, pIHscDlparCIMClient);
                            hashtable = this.doDlparCpuOperation("CPULPARTask", n6, l2, s2, n8, n9, n4, s, bl2, this);
                        }
                        catch (Throwable throwable2) {
                            System.out.println("moveCpu: caught exception trying to recover from failed vary command");
                            throwable2.printStackTrace();
                            string2 = string2 + this.getMessage(throwable2);
                        }
                        throw new PIHscClientException("2927", "HSCCIMExceptionBundle", "2927", new String[]{string2});
                    }
                    System.out.println("DLPAR MOVE: VARIED OFF the PROCESSING------------------------------");
                } else if (!bl2) {
                    System.out.println("DLPAR MOVE: Starting RMC remove Cpu call on source partition ");
                    string2 = string2 + this.getMessage("INFO_REMOVE_RPA", INFO_REMOVE_RPA, new String[]{INFO_PROCESSING_RES});
                    if (n != this.NO_PROCS) {
                        try {
                            if (bl4) {
                                System.out.println("DLPAR MOVE: src partition is multi-cpu capable");
                                this.mRMCClient.rmcDLPARCpuOp(n, this.NO_PROC_UNITS, this.NO_UNCAPPED_WEIGHT, n4, s, "r");
                            } else {
                                System.out.println("DLPAR MOVE: src partition is NOT multi-cpu capable");
                                for (int i = 0; i < n; ++i) {
                                    this.mRMCClient.rmcDLPARCpuOp(1, this.NO_PROC_UNITS, this.NO_UNCAPPED_WEIGHT, n4, s, "r");
                                }
                            }
                            System.out.println("Finished RMC call to REMOVE Procs");
                        }
                        catch (HSCRMCException hSCRMCException) {
                            HSCLogUtils.clientLog(hSCRMCException, HSCLogUtils._DLPARClassLogInfo);
                            System.out.println("RMC REMOVE procs call failed: number of successes = " + hSCRMCException.getNumberOfSuccesses());
                            n17 = hSCRMCException.getNumberOfSuccesses();
                            string2 = string2 + this.getMessage(hSCRMCException);
                            bl3 = true;
                            bl6 = true;
                        }
                        catch (Throwable throwable) {
                            string2 = string2 + this.getMessage(throwable);
                            bl6 = true;
                        }
                        if (bl6) {
                            try {
                                hashtable = pIHscDlparCIMClient.doDlparCpuOperation("CPULPARTask", n13, l4, s2, n15, n16, n4, s, bl2, pIHscDlparCIMClient);
                                hashtable = this.doDlparCpuOperation("CPULPARTask", n6, l2, s2, n8, n9, n4, s, bl2, this);
                            }
                            catch (Throwable throwable) {
                                System.out.println("moveCpu: caught exception trying to recover from failed vary command");
                                throwable.printStackTrace();
                                string2 = string2 + this.getMessage(throwable);
                            }
                            throw new PIHscClientException("2927", "HSCCIMExceptionBundle", "2927", new String[]{string2});
                        }
                    }
                    if (l != this.NO_PROC_UNITS) {
                        try {
                            this.mRMCClient.rmcDLPARCpuOp(this.NO_PROCS, l, this.NO_UNCAPPED_WEIGHT, n4, s, "r");
                            System.out.println("Finished RMC call to REMOVE Proc Units");
                        }
                        catch (HSCRMCException hSCRMCException) {
                            System.out.println(" caught an HSCRMCException " + hSCRMCException);
                            HSCLogUtils.clientLog(hSCRMCException, HSCLogUtils._DLPARClassLogInfo);
                            System.out.println("RMC REMOVE procs call failed: number of successes = " + hSCRMCException.getNumberOfSuccesses());
                            n17 = hSCRMCException.getNumberOfSuccesses();
                            string2 = string2 + this.getMessage(hSCRMCException);
                            bl3 = true;
                            bl6 = true;
                        }
                        catch (Throwable throwable) {
                            System.out.println(" caught a throwable exception ------------");
                            string2 = string2 + this.getMessage(throwable);
                            bl6 = true;
                        }
                        if (bl6) {
                            System.out.println(" handling caught exception");
                            try {
                                hashtable = pIHscDlparCIMClient.doDlparCpuOperation("CPULPARTask", n13, l4, s2, n15, n16, n4, s, bl2, pIHscDlparCIMClient);
                                hashtable = this.doDlparCpuOperation("CPULPARTask", n6, l2, s2, n8, n9, n4, s, bl2, this);
                            }
                            catch (Throwable throwable) {
                                System.out.println("moveCpu: caught exception trying to recover from failed vary command");
                                throwable.printStackTrace();
                                string2 = string2 + this.getMessage(throwable);
                            }
                            System.out.println(" throwing an exception for the caught exception: msg = " + string2);
                            throw new PIHscClientException("2927", "HSCCIMExceptionBundle", "2927", new String[]{string2});
                        }
                    }
                    if (n3 != this.NO_UNCAPPED_WEIGHT) {
                        try {
                            if (n3 < n8) {
                                this.mRMCClient.rmcDLPARCpuOp(this.NO_PROCS, this.NO_PROC_UNITS, (short)(n8 - n3), n4, s, "r");
                                System.out.println("Finished RMC call to REMOVE uncapped weight");
                            } else if (n3 > n8) {
                                this.mRMCClient.rmcDLPARCpuOp(this.NO_PROCS, this.NO_PROC_UNITS, (short)(n3 - n8), n4, s, "a");
                                System.out.println("Finished RMC call to ADD uncapped weight");
                            }
                        }
                        catch (HSCRMCException hSCRMCException) {
                            HSCLogUtils.clientLog(hSCRMCException, HSCLogUtils._DLPARClassLogInfo);
                            System.out.println("RMC REMOVE procUnits call failed: number of successes = " + hSCRMCException.getNumberOfSuccesses());
                            string2 = string2 + this.getMessage(hSCRMCException);
                            bl3 = true;
                        }
                    }
                    System.out.println("Finished RMC remove Cpu call on source partition");
                }
                if (this.isOS400(pIHscDlparCIMClient)) {
                    System.out.println("DLPAR MOVE: START VARY ON the PROCESSING------------------------------");
                    short s4 = this.getPartitionSlotId(pIHscDlparCIMClient.mIntName);
                    System.out.println("destLparID = " + s4);
                    try {
                        this.varyOnOffProcessing(s4, n14, l5, n3, n2, n4);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                        System.out.println("Caught exception while trying to VARY ON processing resources: " + throwable);
                        if (!(throwable instanceof PIHscClientException)) {
                            string2 = string2 + throwable.getMessage();
                            throw new PIHscClientException(string2);
                        }
                        throw (PIHscClientException)throwable;
                    }
                    System.out.println("DLPAR MOVE: VARIED ON the PROCESSING------------------------------");
                    break block87;
                }
                if (bl2) break block87;
                System.out.println("Starting RMC addCpu call");
                string2 = string2 + this.getMessage("INFO_ADD_RPA", INFO_ADD_RPA, new String[]{INFO_PROCESSING_RES});
                System.out.println("destination proc type = " + n12);
                System.out.println("destination procs = " + n14);
                System.out.println("destination proc units = " + l5);
                if (l5 != this.NO_PROC_UNITS) {
                    try {
                        pIHSCRMCClient.rmcDLPARCpuOp(this.NO_PROCS, l5, this.NO_UNCAPPED_WEIGHT, n4, s, "a");
                        System.out.println("Finished RMC call to add Proc Units");
                    }
                    catch (HSCRMCException hSCRMCException) {
                        HSCLogUtils.clientLog(hSCRMCException, HSCLogUtils._DLPARClassLogInfo);
                        System.out.println("RMC add procUnits call failed: number of successes = " + hSCRMCException.getNumberOfSuccesses());
                        string2 = string2 + this.getMessage(hSCRMCException);
                        bl3 = true;
                    }
                }
                if (n14 != this.NO_PROCS) {
                    try {
                        if (bl5) {
                            System.out.println("DLPAR Move: destination partition is multi-cpu capable");
                            pIHSCRMCClient.rmcDLPARCpuOp(n14, this.NO_PROC_UNITS, this.NO_UNCAPPED_WEIGHT, n4, s, "a");
                        } else {
                            System.out.println("DLPAR Move: destination partition is NOT multi-cpu capable");
                            for (int i = 0; i < n14; ++i) {
                                pIHSCRMCClient.rmcDLPARCpuOp(1, this.NO_PROC_UNITS, this.NO_UNCAPPED_WEIGHT, n4, s, "a");
                            }
                        }
                        System.out.println("Finished RMC call to add Procs");
                    }
                    catch (HSCRMCException hSCRMCException) {
                        HSCLogUtils.clientLog(hSCRMCException, HSCLogUtils._DLPARClassLogInfo);
                        System.out.println("RMC add procs call failed: number of successes = " + hSCRMCException.getNumberOfSuccesses());
                        string2 = string2 + this.getMessage(hSCRMCException);
                        bl3 = true;
                    }
                }
                if (n3 != this.NO_UNCAPPED_WEIGHT) {
                    try {
                        if (n3 < n8) {
                            pIHSCRMCClient.rmcDLPARCpuOp(this.NO_PROCS, this.NO_PROC_UNITS, (short)(n15 - n3), n4, s, "r");
                            System.out.println("Finished RMC call to Remove uncapped weight");
                        } else if (n3 > n8) {
                            pIHSCRMCClient.rmcDLPARCpuOp(this.NO_PROCS, this.NO_PROC_UNITS, (short)(n3 - n15), n4, s, "a");
                            System.out.println("Finished RMC call to add uncapped weight");
                        }
                    }
                    catch (HSCRMCException hSCRMCException) {
                        HSCLogUtils.clientLog(hSCRMCException, HSCLogUtils._DLPARClassLogInfo);
                        System.out.println("RMC add procUnits call failed: number of successes = " + hSCRMCException.getNumberOfSuccesses());
                        string2 = string2 + this.getMessage(hSCRMCException);
                        bl3 = true;
                    }
                }
                System.out.println("DLPAR MOVE: Finished RMC add Cpu call for dest");
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                if (!(throwable instanceof PIHscClientException)) {
                    string2 = string2 + throwable.getMessage();
                    throw new PIHscClientException("2927", "HSCCIMExceptionBundle", "2927", new String[]{string2});
                }
                throw (PIHscClientException)throwable;
            }
        }
        if (bl3) {
            throw new PIHscClientException("2927", "HSCCIMExceptionBundle", "2927", new String[]{string2});
        }
        if (n == this.NO_PROCS) {
            if (l == this.NO_PROC_UNITS) {
                return 1;
            }
            return (int)l;
        }
        return n;
    }

    public int setCpu(short s, int n, int n2, int n3, boolean bl) throws PIHscClientException {
        System.out.println("in setCpu /////////////////////////////////////");
        System.out.println("sharing mode = " + s);
        System.out.println("interactive = " + n2);
        System.out.println("uncappedWeight = " + n);
        System.out.println("Timeout = " + n3);
        System.out.println("Starting setCpu call");
        String string = this.getPartitionType();
        int n4 = -1;
        long l = -1L;
        Hashtable hashtable = new Hashtable();
        short s2 = 4;
        hashtable = this.doDlparCpuOperationAdd("addCpu", n4, l, s, n, n2, n3, s2, bl, this);
        System.out.println("Finished setCpu call");
        return 0;
    }

    public Hashtable getProcessorData() throws PIHscClientException {
        try {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            System.out.println("in getProcessorData -----------------------------------");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "getProcessorData", vector, vector2);
            Hashtable<String, Number> hashtable = new Hashtable<String, Number>();
            short s = 0;
            int n = 0;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            int n2 = 0;
            long l4 = 0L;
            int n3 = 0;
            long l5 = 0L;
            short s2 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            s = vector2.elementAt(0) instanceof CIMValue ? ((UnsignedInt8)((CIMValue)vector2.elementAt(0)).getValue()).shortValue() : ((UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue()).shortValue();
            if (vector2.elementAt(0) instanceof CIMValue) {
                l2 = ((UnsignedInt32)((CIMValue)vector2.elementAt(1)).getValue()).longValue();
                n = ((UnsignedInt16)((CIMValue)vector2.elementAt(2)).getValue()).intValue();
                n2 = ((UnsignedInt16)((CIMValue)vector2.elementAt(3)).getValue()).intValue();
                n3 = ((UnsignedInt16)((CIMValue)vector2.elementAt(4)).getValue()).intValue();
                l = ((UnsignedInt32)((CIMValue)vector2.elementAt(5)).getValue()).longValue();
                l4 = ((UnsignedInt32)((CIMValue)vector2.elementAt(6)).getValue()).longValue();
                l5 = ((UnsignedInt32)((CIMValue)vector2.elementAt(7)).getValue()).longValue();
                s2 = ((UnsignedInt8)((CIMValue)vector2.elementAt(8)).getValue()).shortValue();
                n4 = ((UnsignedInt16)((CIMValue)vector2.elementAt(9)).getValue()).intValue();
                n5 = ((UnsignedInt16)((CIMValue)vector2.elementAt(10)).getValue()).intValue();
                n6 = ((UnsignedInt16)((CIMValue)vector2.elementAt(11)).getValue()).intValue();
                n7 = ((UnsignedInt16)((CIMValue)vector2.elementAt(12)).getValue()).intValue();
            } else {
                l2 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(1)).getValue().getValue()).longValue();
                n = ((UnsignedInt16)((CIMProperty)vector2.elementAt(2)).getValue().getValue()).intValue();
                n2 = ((UnsignedInt16)((CIMProperty)vector2.elementAt(3)).getValue().getValue()).intValue();
                n3 = ((UnsignedInt16)((CIMProperty)vector2.elementAt(4)).getValue().getValue()).intValue();
                l = ((UnsignedInt32)((CIMProperty)vector2.elementAt(5)).getValue().getValue()).longValue();
                l4 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(6)).getValue().getValue()).longValue();
                l5 = ((UnsignedInt32)((CIMProperty)vector2.elementAt(7)).getValue().getValue()).longValue();
                s2 = ((UnsignedInt8)((CIMProperty)vector2.elementAt(8)).getValue().getValue()).shortValue();
                n4 = ((UnsignedInt16)((CIMProperty)vector2.elementAt(9)).getValue().getValue()).intValue();
                n5 = ((UnsignedInt16)((CIMProperty)vector2.elementAt(10)).getValue().getValue()).intValue();
                n6 = ((UnsignedInt16)((CIMProperty)vector2.elementAt(11)).getValue().getValue()).intValue();
                n7 = ((UnsignedInt16)((CIMProperty)vector2.elementAt(12)).getValue().getValue()).intValue();
            }
            if (s == 255) {
                System.out.println(" ----- DEDICATED ------ ");
                System.out.println("avail Procs = " + l2);
                System.out.println("cur Procs = " + n);
                System.out.println("max Procs = " + n2);
                System.out.println("min Procs = " + n3);
            } else {
                System.out.println(" ----- SHARED ------ ");
                System.out.println("avail Virt Procs = " + l2);
                System.out.println("cur Virt Procs = " + n);
                System.out.println("max Virt Procs = " + n2);
                System.out.println("min Virt Procs = " + n3);
                System.out.println("avail Virt Procs = " + l2);
                System.out.println("cur Virt Procs = " + n);
                System.out.println("max Virt Procs = " + n2);
                System.out.println("min Virt Procs = " + n3);
                System.out.println("curProcUnits = " + l);
                System.out.println("maxProcUnits = " + l4);
                System.out.println("minProcUnits = " + l5);
                System.out.println("sharingMode = " + s2);
                System.out.println("uncappedWeight = " + n4);
            }
            System.out.println("curInteractivePerf = " + n5);
            System.out.println("maxInteractivePerf = " + n6);
            System.out.println("minInteractivePerf = " + n7);
            hashtable.put("CurProcMode", new Short(s));
            hashtable.put("CurAvailProcUnits", new Long(l2));
            hashtable.put("CurAllocProcs", new Integer(n));
            hashtable.put("CurMaxProcs", new Integer(n2));
            hashtable.put("CurMinProcs", new Integer(n3));
            hashtable.put("CurAllocProcUnits", new Long(l));
            hashtable.put("CurMaxProcUnits", new Long(l4));
            hashtable.put("CurMinProcUnits", new Long(l5));
            hashtable.put("CurSharingMode", new Short(s2));
            hashtable.put("CurUncappedWeight", new Integer(n4));
            hashtable.put("CurAllocInteractivePerf", new Integer(n5));
            hashtable.put("CurMaxInteractivePerf", new Integer(n6));
            hashtable.put("CurMinInteractivePerf", new Integer(n7));
            return hashtable;
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public Hashtable doDlparCpuOperation(String string, int n, long l, short s, int n2, int n3, int n4, short s2, boolean bl, PIHscDlparCIMClient pIHscDlparCIMClient) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        short s3 = 0;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (pIHscDlparCIMClient == this) {
            s3 = this.getPartitionSlotId(this.mIntName);
        } else if (pIHscDlparCIMClient != null) {
            s3 = pIHscDlparCIMClient.getPartitionSlotId(pIHscDlparCIMClient.mIntName);
        } else {
            System.out.println("in doDlparCpuOperation: dest client is null...............");
        }
        System.out.println("in doDlparCpuOperation: destSlotId = " + s3);
        vector.addElement(new CIMProperty("lparID", new CIMValue((Object)new UnsignedInt16((int)s3))));
        vector.addElement(new CIMProperty("numProcs", new CIMValue((Object)new UnsignedInt16(n))));
        vector.addElement(new CIMProperty("numProcUnits", new CIMValue((Object)new UnsignedInt32(l))));
        vector.addElement(new CIMProperty("sharingMode", new CIMValue((Object)new UnsignedInt8(s))));
        vector.addElement(new CIMProperty("uncappedWeight", new CIMValue((Object)new UnsignedInt16(n2))));
        vector.addElement(new CIMProperty("interactive", new CIMValue((Object)new UnsignedInt16(n3))));
        try {
            System.out.println("Start calling cpu CIM method");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, string, vector, vector2);
            System.out.println("Finish calling cpu CIM method");
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "HSCCIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            pIHscClientException.printStackTrace();
            throw pIHscClientException;
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
            System.out.println("exception invoking CIMMethod in doDlparCpuOperation ======= " + throwable);
            throw new PIHscClientException(throwable.getMessage());
        }
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt32 unsignedInt32 = null;
        UnsignedInt16 unsignedInt162 = null;
        UnsignedInt16 unsignedInt163 = null;
        System.out.println("outParams SIZE ================ " + vector2.size());
        if (vector2.size() > 0) {
            if (GlobalConfig.callMethodsWithValues) {
                unsignedInt16 = (UnsignedInt16)((CIMValue)vector2.elementAt(0)).getValue();
                unsignedInt32 = (UnsignedInt32)((CIMValue)vector2.elementAt(1)).getValue();
                unsignedInt162 = (UnsignedInt16)((CIMValue)vector2.elementAt(2)).getValue();
                unsignedInt163 = (UnsignedInt16)((CIMValue)vector2.elementAt(3)).getValue();
            } else {
                unsignedInt16 = (UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                unsignedInt32 = (UnsignedInt32)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                unsignedInt162 = (UnsignedInt16)((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                unsignedInt163 = (UnsignedInt16)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
            }
            hashtable.put("CPUSuccesses", unsignedInt16);
            hashtable.put("ProcUnitSuccesses", unsignedInt32);
            hashtable.put("UncappedWeight", unsignedInt162);
            hashtable.put("Interactive", unsignedInt163);
            return hashtable;
        }
        return null;
    }

    public Hashtable doDlparCpuOperationAdd(String string, int n, long l, short s, int n2, int n3, int n4, short s2, boolean bl, PIHscDlparCIMClient pIHscDlparCIMClient) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        short s3 = 0;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        if (pIHscDlparCIMClient == this) {
            s3 = this.getPartitionSlotId(this.mIntName);
        } else if (pIHscDlparCIMClient != null) {
            s3 = pIHscDlparCIMClient.getPartitionSlotId(pIHscDlparCIMClient.mIntName);
        } else {
            System.out.println("in doDlparCpuOperationAdd: dest client is null...............");
        }
        System.out.println("in doDlparCpuOperationAdd: destSlotId = " + s3);
        vector.addElement(new CIMProperty("numProcs", new CIMValue((Object)new UnsignedInt16(n))));
        vector.addElement(new CIMProperty("numProcUnits", new CIMValue((Object)new UnsignedInt32(l))));
        vector.addElement(new CIMProperty("sharingMode", new CIMValue((Object)new UnsignedInt8(s))));
        vector.addElement(new CIMProperty("uncappedWeight", new CIMValue((Object)new UnsignedInt16(n2))));
        vector.addElement(new CIMProperty("interactive", new CIMValue((Object)new UnsignedInt16(n3))));
        vector.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n4))));
        vector.addElement(new CIMProperty("detailLevel", new CIMValue((Object)new UnsignedInt8(s2))));
        vector.addElement(new CIMProperty("noRMCConnection", new CIMValue((Object)new Boolean(bl))));
        if ("moveCpu".equals(string)) {
            vector.addElement(new CIMProperty("lparID", new CIMValue((Object)new UnsignedInt16((int)s3))));
        }
        try {
            System.out.println("Start calling addCpu CIM method");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, string, vector, vector2);
            System.out.println("Finish calling cpu CIM method");
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "HSCCIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            pIHscClientException.printStackTrace();
            throw pIHscClientException;
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
            System.out.println("exception invoking CIMMethod in doDlparCpuOperation ======= " + throwable);
            throwable.printStackTrace();
            throw new PIHscClientException(throwable.getMessage());
        }
        Boolean bl2 = null;
        String string2 = null;
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt32 unsignedInt32 = null;
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt16 unsignedInt162 = null;
        System.out.println("outParams SIZE ================ " + vector2.size());
        if (vector2.size() > 0) {
            if (GlobalConfig.callMethodsWithValues) {
                bl2 = (Boolean)((CIMValue)vector2.elementAt(0)).getValue();
                string2 = (String)((CIMValue)vector2.elementAt(1)).getValue();
                unsignedInt16 = (UnsignedInt16)((CIMValue)vector2.elementAt(2)).getValue();
                unsignedInt32 = (UnsignedInt32)((CIMValue)vector2.elementAt(3)).getValue();
                unsignedInt8 = (UnsignedInt8)((CIMValue)vector2.elementAt(4)).getValue();
                unsignedInt162 = (UnsignedInt16)((CIMValue)vector2.elementAt(5)).getValue();
            } else {
                bl2 = (Boolean)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                string2 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                unsignedInt16 = (UnsignedInt16)((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                unsignedInt32 = (UnsignedInt32)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                unsignedInt8 = (UnsignedInt8)((CIMProperty)vector2.elementAt(4)).getValue().getValue();
                unsignedInt162 = (UnsignedInt16)((CIMProperty)vector2.elementAt(5)).getValue().getValue();
            }
            hashtable.put("IsError", bl2);
            hashtable.put("CPUSuccesses", (Boolean)unsignedInt16);
            hashtable.put("ProcUnitSuccesses", (Boolean)unsignedInt32);
            hashtable.put("UncappedWeight", (Boolean)unsignedInt8);
            hashtable.put("Interactive", (Boolean)unsignedInt162);
            return hashtable;
        }
        return null;
    }

    private void varyOnOffProcessing(int n, int n2, long l, int n3, int n4, int n5) throws PIHscClientException {
        System.out.println("IN varyOnOffProcessing: ");
        System.out.println("lparID = " + n);
        System.out.println("numProcs = " + n2);
        System.out.println("numProcUnits = " + l);
        System.out.println("uncappedWeight = " + n3);
        System.out.println("interactive = " + n4);
        System.out.println("timeout = " + n5);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMProperty("lparID", new CIMValue((Object)new UnsignedInt16(n))));
        vector.addElement(new CIMProperty("numProcs", new CIMValue((Object)new UnsignedInt16(n2))));
        vector.addElement(new CIMProperty("numProcUnits", new CIMValue((Object)new UnsignedInt32(l))));
        vector.addElement(new CIMProperty("uncappedWeight", new CIMValue((Object)new UnsignedInt16(n3))));
        vector.addElement(new CIMProperty("interactive", new CIMValue((Object)new UnsignedInt16(n4))));
        vector.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n5))));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "varyOnOffProcessing", vector, vector2);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    private void getIoSlotInfo(PIIOSlotDataBean pIIOSlotDataBean, String string) throws PIHscClientException {
        System.err.println(this.getClass() + ".getIoSlotInfo()");
        String string2 = pIIOSlotDataBean.getBusID();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMProperty("busId", new CIMValue((Object)new UnsignedInt16(string2))));
        vector.addElement(new CIMProperty("maxIndex", new CIMValue((Object)new UnsignedInt16(1))));
        vector.addElement(new CIMProperty("DRCIndex", new CIMValue((Object)new UnsignedInt32(2L))));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "getIoSlotInfo", vector, vector2);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    private int addIo(PIHscDlparCIMClient pIHscDlparCIMClient, String[] stringArray, Integer[] integerArray, int n, short s, boolean bl) throws PIHscClientException, HSCRMCException {
        Serializable serializable;
        boolean bl2 = false;
        Hashtable hashtable = null;
        PIIOSlotDataBean pIIOSlotDataBean = null;
        boolean bl3 = false;
        boolean bl4 = false;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Hashtable hashtable2 = new Hashtable();
        boolean[] blArray = null;
        String[] stringArray2 = null;
        UnsignedInt32[] unsignedInt32Array = null;
        UnsignedInt16[] unsignedInt16Array = null;
        UnsignedInt16[] unsignedInt16Array2 = null;
        int n2 = 0;
        boolean bl5 = false;
        String string = null;
        String string2 = null;
        PIHscDlparCIMClient.debug(this.getClass() + "addIO()");
        Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
        try {
            int n3;
            string = this.getMessage("INFO_ADD_HMC", INFO_ADD_HMC, new String[]{INFO_SLOT_RES});
            hashtable = this.getIoData(pIHscDlparCIMClient);
            if (integerArray[0] == this.NO_POOL_ID) {
                pIIOSlotDataBean = this.getIoSlot(hashtable, stringArray[0]);
                UnsignedInt16 unsignedInt16 = pIIOSlotDataBean.getIoPool();
                integerArray[0] = unsignedInt16 == null ? new Integer(65535) : new Integer(unsignedInt16.intValue());
            }
            n2 = stringArray.length;
            blArray = new boolean[n2];
            stringArray2 = new String[n2];
            unsignedInt32Array = new UnsignedInt32[n2];
            unsignedInt16Array = new UnsignedInt16[n2];
            unsignedInt16Array2 = new UnsignedInt16[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                pIIOSlotDataBean = this.getIoSlot(hashtable, stringArray[n3]);
                if (pIIOSlotDataBean == null) {
                    blArray[n3] = false;
                    bl3 = true;
                    long l = Long.parseLong(stringArray[n3]);
                    System.out.println(" INVALID_SLOT_ARGUMENT_SPECIFIED: no data bean for slot.... " + Long.toString(l, 16));
                    string = string + INVALID_SLOT_ARGUMENT_SPECIFIED;
                    string = string + " ";
                    string = string + Long.toString(l, 16);
                    continue;
                }
                if (pIIOSlotDataBean.getOwnerClass().shortValue() != 0) {
                    blArray[n3] = false;
                    bl3 = true;
                    long l = Long.parseLong(stringArray[n3]);
                    System.out.println(" slot not stopped.... " + Long.toString(l, 16));
                    string = string + ERR_SLOT_NOT_STOPPED;
                    string = string + " ";
                    string = string + Long.toString(l, 16);
                    continue;
                }
                if (this.isRPA(pIHscDlparCIMClient) && !bl) {
                    String string3 = pIIOSlotDataBean.getBusID();
                    Integer n4 = (Integer)hashtable3.get(string3);
                    if (n4 != null) {
                        int n5 = n4 + 1;
                        hashtable3.put(string3, new Integer(n5));
                        System.out.println("PHB already varied ON --------------------");
                        System.out.println("numSlotsUnderPHB = " + n5);
                        blArray[n3] = true;
                        unsignedInt32Array[n3] = new UnsignedInt32(stringArray[n3]);
                        unsignedInt16Array[n3] = new UnsignedInt16(integerArray[n3].intValue());
                        stringArray2[n3] = pIIOSlotDataBean.getDrcName();
                        unsignedInt16Array2[n3] = pIIOSlotDataBean.getOwner();
                        continue;
                    }
                    if (!this.busHasActiveSlots(string3, this.lparId(pIHscDlparCIMClient), hashtable)) {
                        PIIOBusDataBean pIIOBusDataBean = this.getIoBus(hashtable, string3);
                        string2 = pIIOBusDataBean.getBusDrcName();
                        System.out.println("Call to vary on PHB. phb DRC name = " + string2);
                        try {
                            serializable = this.varyOnOffPHB(string2, n, s, "a", this.lparId(pIHscDlparCIMClient), bl);
                            boolean bl6 = (Boolean)((Hashtable)serializable).get("IsError");
                            if (bl6) {
                                blArray[n3] = false;
                                bl3 = true;
                                string = string + (String)((Hashtable)serializable).get("InfoMsg");
                                continue;
                            }
                            System.out.println("ADDING PHB " + string3);
                            hashtable3.put(string3, new Integer(1));
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                            blArray[n3] = false;
                            bl3 = true;
                            string = string + throwable.getMessage();
                            continue;
                        }
                    }
                }
                blArray[n3] = true;
                unsignedInt32Array[n3] = new UnsignedInt32(stringArray[n3]);
                unsignedInt16Array[n3] = new UnsignedInt16(integerArray[n3].intValue());
                stringArray2[n3] = pIIOSlotDataBean.getDrcName();
                unsignedInt16Array2[n3] = pIIOSlotDataBean.getOwner();
            }
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                System.out.println("physical location codes = " + stringArray2[n3]);
            }
            hashtable2.put("DRCIndex", unsignedInt32Array);
            hashtable2.put("PhyLocCode", stringArray2);
            hashtable2.put("poolID", unsignedInt16Array);
            hashtable2.put("SrcLparID", unsignedInt16Array2);
            if (bl3) {
                hashtable2 = this.slotInfoTrim(hashtable2, blArray, false);
            }
            if (hashtable2.size() == 0) {
                System.out.println(" got trimmed totally --- ");
                throw new PIHscClientException("2928", "HSCCIMExceptionBundle", "2928", new String[]{string});
            }
            vector = this.doDlparIoOperation("addIo", hashtable2, pIHscDlparCIMClient, n, s, bl);
            System.out.println("got a good set of results : " + vector);
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
            if (!(throwable instanceof PIHscClientException)) {
                string = string + throwable.getMessage();
                System.out.println(" got an except = " + string);
                throw new PIHscClientException("2928", "HSCCIMExceptionBundle", "2928", new String[]{string});
            }
            System.out.println(" got an PIHscClientException except = " + string);
            throw (PIHscClientException)throwable;
        }
        if (null == vector && !bl3) {
            System.out.println("addIo: SUCCESS------------------");
            return n2;
        }
        if (null == vector) {
            System.out.println("got a good set of results : " + vector);
            string = string + this.getMessage("INFO_ADD_HMC_SUCC", INFO_ADD_HMC_SUCC, new String[]{INFO_SLOT_RES});
            throw new PIHscClientException("2928", "HSCCIMExceptionBundle", "2928", new String[]{string});
        }
        System.out.println("got a bad set of results : " + vector);
        string = string + (String)vector.elementAt(0);
        if (this.isRPA(pIHscDlparCIMClient) && !bl) {
            blArray = (boolean[])vector.elementAt(1);
            if ((hashtable2 = this.slotInfoTrim(hashtable2, blArray, true)).size() == 0) {
                System.out.println("BIZARRE behavior: - failure but no failures in results....");
                throw new PIHscClientException("2928", "HSCCIMExceptionBundle", "2928", new String[]{string});
            }
            Vector<String> vector3 = new Vector<String>();
            UnsignedInt32[] unsignedInt32Array2 = (UnsignedInt32[])hashtable2.get("DRCIndex");
            n2 = unsignedInt32Array2.length;
            System.out.println("PHB rollback: failed slots = " + n2);
            for (int i = 0; i < n2; ++i) {
                pIIOSlotDataBean = this.getIoSlot(hashtable, unsignedInt32Array2[0].toString());
                String string4 = pIIOSlotDataBean.getBusID();
                serializable = (Integer)hashtable3.get(string4);
                if (serializable != null) {
                    int n6 = (Integer)serializable - 1;
                    hashtable3.put(string4, new Integer(n6));
                    if (n6 != 0) {
                        System.out.println("STILL ADDED SLOTS UNDER THIS PHB -------------- ");
                        System.out.println("numSlotsUnderPHB = " + n6);
                        continue;
                    }
                } else {
                    System.out.println("in addIo: no PHB ever added for slot --------");
                    continue;
                }
                if (this.busHasActiveSlots(pIIOSlotDataBean.getBusID(), this.lparId(pIHscDlparCIMClient), hashtable)) continue;
                PIIOBusDataBean pIIOBusDataBean = this.getIoBus(hashtable, string4);
                string2 = pIIOBusDataBean.getBusDrcName();
                System.out.println("must roll back phb : " + string2);
                vector3.addElement(string2);
            }
            Enumeration enumeration = vector3.elements();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                try {
                    Hashtable hashtable4 = this.varyOnOffPHB(string2, n, s, "a", this.lparId(pIHscDlparCIMClient), bl);
                    boolean bl7 = (Boolean)hashtable4.get("IsError");
                    if (!bl7) continue;
                    string = string + (String)hashtable4.get("InfoMsg");
                }
                catch (Throwable throwable) {
                    HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                    string = string + throwable.getMessage();
                }
            }
        }
        throw new PIHscClientException("2928", "HSCCIMExceptionBundle", "2928", new String[]{string});
    }

    public int removeIo(PIHscDlparCIMClient pIHscDlparCIMClient, String[] stringArray, Integer[] integerArray, int n, short s, boolean bl) throws PIHscClientException, HSCRMCException {
        PIHscDlparCIMClient.debug(this.getClass() + "removeIO()");
        String[] stringArray2 = null;
        UnsignedInt32[] unsignedInt32Array = null;
        UnsignedInt16[] unsignedInt16Array = null;
        Hashtable hashtable = new Hashtable();
        boolean[] blArray = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        int n2 = -1;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        Hashtable hashtable2 = null;
        int n4 = this.lparId(pIHscDlparCIMClient);
        hashtable2 = this.getIoData(pIHscDlparCIMClient);
        PIIOSlotDataBean pIIOSlotDataBean = null;
        n3 = stringArray.length;
        blArray = new boolean[n3];
        stringArray2 = new String[n3];
        unsignedInt32Array = new UnsignedInt32[n3];
        unsignedInt16Array = new UnsignedInt16[n3];
        Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
        String string = this.getMessage("INFO_REMOVE_HMC", INFO_REMOVE_HMC, new String[]{INFO_SLOT_RES});
        if (integerArray[0] == this.NO_POOL_ID) {
            pIIOSlotDataBean = this.getIoSlot(hashtable2, stringArray[0]);
            UnsignedInt16 unsignedInt16 = pIIOSlotDataBean.getIoPool();
            integerArray[0] = unsignedInt16 == null ? new Integer(65535) : new Integer(unsignedInt16.intValue());
        }
        for (int i = 0; i < n3; ++i) {
            pIIOSlotDataBean = this.getIoSlot(hashtable2, stringArray[i]);
            if (pIIOSlotDataBean == null) {
                blArray[i] = false;
                bl2 = true;
                long l = Long.parseLong(stringArray[i]);
                System.out.println(" INVALID_SLOT_ARGUMENT_SPECIFIED: no data bean for slot.... " + Long.toString(l, 16));
                string = string + INVALID_SLOT_ARGUMENT_SPECIFIED;
                string = string + " ";
                string = string + Long.toString(l, 16);
                continue;
            }
            UnsignedInt16 unsignedInt16 = pIIOSlotDataBean.getOwner();
            if (pIIOSlotDataBean.getOwnerId().intValue() != n4 || pIIOSlotDataBean.getOwnerClass().shortValue() != 2) {
                blArray[i] = false;
                bl2 = true;
                long l = Long.parseLong(stringArray[i]);
                System.out.println(" ERR_SLOT_SRC_PAR: The slot doesn't belong to the source logical partition." + Long.toString(l, 16));
                string = string + ERR_SLOT_SRC_PAR;
                string = string + " ";
                string = string + Long.toString(l, 16);
                continue;
            }
            blArray[i] = true;
            unsignedInt32Array[i] = new UnsignedInt32(stringArray[i]);
            unsignedInt16Array[i] = new UnsignedInt16(integerArray[i].intValue());
            stringArray2[i] = pIIOSlotDataBean.getDrcName();
        }
        hashtable.put("DRCIndex", unsignedInt32Array);
        hashtable.put("PhyLocCode", stringArray2);
        hashtable.put("poolID", unsignedInt16Array);
        if (bl2) {
            hashtable = this.slotInfoTrim(hashtable, blArray, false);
        }
        if (hashtable.size() == 0) {
            System.out.println(" got trimmed totally --- ");
            throw new PIHscClientException("2929", "HSCCIMExceptionBundle", "2929", new String[]{string});
        }
        try {
            vector3 = this.doDlparIoOperation("removeIo", hashtable, pIHscDlparCIMClient, n, s, bl);
            System.out.println("returned from doDlparIoOperation......................");
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
            if (!(throwable instanceof PIHscClientException)) {
                string = string + throwable.getMessage();
                System.out.println(" got an except = " + string);
                throw new PIHscClientException("2928", "HSCCIMExceptionBundle", "2928", new String[]{string});
            }
            System.out.println(" got an PIHscClientException except = " + string);
            throw (PIHscClientException)throwable;
        }
        if (null == vector3) {
            string = string + this.getMessage("INFO_ADD_HMC_SUCC", INFO_ADD_HMC_SUCC, new String[]{INFO_SLOT_RES});
        } else {
            string = string + (String)vector3.elementAt(0);
            blArray = (boolean[])vector3.elementAt(1);
            hashtable = this.slotInfoTrim(hashtable, blArray, false);
            bl2 = true;
        }
        if (this.isOS400(pIHscDlparCIMClient)) {
            if (null == vector3 && !bl2) {
                System.out.println("OS400 successfull remove IO");
                return n3;
            }
            System.out.println("had some kind of failure in OS400 remove io");
            throw new PIHscClientException("2929", "HSCCIMExceptionBundle", "2929", new String[]{string});
        }
        if (hashtable.size() == 0) {
            throw new PIHscClientException("2929", "HSCCIMExceptionBundle", "2929", new String[]{string});
        }
        if (!bl) {
            int n5;
            UnsignedInt32[] unsignedInt32Array2 = (UnsignedInt32[])hashtable.get("DRCIndex");
            blArray = new boolean[unsignedInt32Array2.length];
            for (n5 = 0; n5 < unsignedInt32Array2.length; ++n5) {
                System.out.println("good slot = " + unsignedInt32Array2[n5].toString());
            }
            hashtable2 = this.getIoData(pIHscDlparCIMClient);
            for (n5 = 0; n5 < unsignedInt32Array2.length; ++n5) {
                pIIOSlotDataBean = this.getIoSlot(hashtable2, unsignedInt32Array2[n5].toString());
                if (pIIOSlotDataBean == null) {
                    System.out.println("can't get slot databean for PHB remove");
                    continue;
                }
                String string2 = pIIOSlotDataBean.getBusID();
                Integer n6 = (Integer)hashtable3.get(string2);
                if (n6 != null) {
                    int n7 = n6 + 1;
                    hashtable3.put(string2, new Integer(n7));
                    System.out.println("PHB already varied OFF skip it --------------------");
                    System.out.println("Number of slots (so far) under this PHB: " + n7);
                    blArray[n5] = true;
                    continue;
                }
                if (!this.busHasActiveSlots(string2, this.lparId(pIHscDlparCIMClient), hashtable2)) {
                    System.out.println("BUS NO LONGER HAS ACTIVE SLOTS  --  REMOVE PHB " + string2);
                    PIIOBusDataBean pIIOBusDataBean = this.getIoBus(hashtable2, string2);
                    String string3 = pIIOBusDataBean.getBusDrcName();
                    if (null == string3) {
                        System.out.println("can't get PHB DRC Name - skip it");
                        continue;
                    }
                    try {
                        Hashtable hashtable4 = this.varyOnOffPHB(string3, n, s, "r", this.lparId(pIHscDlparCIMClient), bl);
                        boolean bl4 = (Boolean)hashtable4.get("IsError");
                        if (bl4) {
                            System.out.println("got an ERROR trying the RMC vary off PHB...");
                            System.out.println("msg = " + (String)hashtable4.get("InfoMsg"));
                            blArray[n5] = false;
                            bl2 = true;
                            string = string + (String)hashtable4.get("InfoMsg");
                            continue;
                        }
                        System.out.println("REMOVING PHB " + string2);
                        hashtable3.put(string2, new Integer(1));
                        System.out.println(" SUCCESSFULLY removed PHB " + string3);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                        System.out.println("caught exception trying to vary off phb " + string3);
                        System.out.println("exception = " + throwable);
                        throwable.printStackTrace();
                        blArray[n5] = false;
                        string = string + throwable.getMessage();
                        bl2 = true;
                        continue;
                    }
                }
                blArray[n5] = true;
            }
            if ((hashtable = this.slotInfoTrim(hashtable, blArray, true)).size() == 0) {
                System.out.println("Successfully removed all PHBs of successfully removed slots");
                if (!bl2) {
                    System.out.println(" --- and there were NO previous errors... ");
                    return n3;
                }
                System.out.println(" --- but there were previous errors... ");
                throw new PIHscClientException("2929", "HSCCIMExceptionBundle", "2929", new String[]{string});
            }
            System.out.println(" roll em roll em roll em --- back");
            string = string + this.getMessage("INFO_HMC_ROLLBACK_ADD", INFO_HMC_ROLLBACK_ADD, new String[]{INFO_SLOT_RES});
            try {
                vector3 = this.doDlparIoOperation("addIo", hashtable, pIHscDlparCIMClient, n, s, bl);
                System.out.println("no exceptions in rollback----- ");
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
                string = string + throwable.getMessage();
                string = string + ERR_OUT_OF_SYNC;
                System.out.println("got an exception trying to rollback");
                throw new PIHscClientException("2929", "HSCCIMExceptionBundle", "2929", new String[]{string});
            }
            if (null == vector3) {
                System.out.println("ROLLBACK was successful.....");
                string = string + INFO_HMC_ROLLBACK_SUCC;
            } else {
                string = string + (String)vector3.elementAt(0);
                string = string + ERR_OUT_OF_SYNC;
            }
            throw new PIHscClientException("2929", "HSCCIMExceptionBundle", "2929", new String[]{string});
        }
        return n3;
    }

    private PIIOSlotDataBean getIoSlot(PIHscDlparCIMClient pIHscDlparCIMClient, String string) throws PIHscClientException {
        PIIOSlotDataBean pIIOSlotDataBean = this.getIoSlot(this.getIoData(pIHscDlparCIMClient), string);
        if (pIIOSlotDataBean != null) {
            this.checkSlotStatus(pIIOSlotDataBean);
        }
        return pIIOSlotDataBean;
    }

    private PIIOSlotDataBean getIoSlot(Hashtable hashtable, String string) {
        Enumeration enumeration = hashtable.elements();
        PIIOSlotDataBean pIIOSlotDataBean = null;
        while (enumeration.hasMoreElements()) {
            PIDataBeanInterface pIDataBeanInterface;
            Object v = enumeration.nextElement();
            if (v instanceof PIIODrawerDataBean && (pIIOSlotDataBean = this.getIoSlot(((PIIODrawerDataBean)(pIDataBeanInterface = (PIIODrawerDataBean)v)).getBuses(), string)) != null) {
                return pIIOSlotDataBean;
            }
            if (v instanceof PIIOBusDataBean && (pIIOSlotDataBean = this.getIoSlot(((PIIOBusDataBean)(pIDataBeanInterface = (PIIOBusDataBean)v)).getSlots(), string)) != null) {
                return pIIOSlotDataBean;
            }
            if (!(v instanceof PIIOSlotDataBean) || !((PIIOSlotDataBean)(pIDataBeanInterface = (PIIOSlotDataBean)v)).getDrcIndex().equals(string)) continue;
            return pIDataBeanInterface;
        }
        return pIIOSlotDataBean;
    }

    private PIIOBusDataBean getIoBus(PIHscDlparCIMClient pIHscDlparCIMClient, String string) throws PIHscClientException {
        PIIOBusDataBean pIIOBusDataBean = this.getIoBus(this.getIoData(pIHscDlparCIMClient), string);
        return pIIOBusDataBean;
    }

    private PIIOBusDataBean getIoBus(Hashtable hashtable, String string) {
        Enumeration enumeration = hashtable.elements();
        PIIOBusDataBean pIIOBusDataBean = null;
        while (enumeration.hasMoreElements()) {
            PIDataBeanInterface pIDataBeanInterface;
            Object v = enumeration.nextElement();
            if (v instanceof PIIODrawerDataBean && (pIIOBusDataBean = this.getIoBus(((PIIODrawerDataBean)(pIDataBeanInterface = (PIIODrawerDataBean)v)).getBuses(), string)) != null) {
                return pIIOBusDataBean;
            }
            if (!(v instanceof PIIOBusDataBean) || !((PIIOBusDataBean)(pIDataBeanInterface = (PIIOBusDataBean)v)).getBusID().equals(string)) continue;
            return pIDataBeanInterface;
        }
        return pIIOBusDataBean;
    }

    public Hashtable getIoData(PIHscDlparCIMClient pIHscDlparCIMClient) throws PIHscClientException {
        PIHscDlparCIMClient.debug(this.getClass() + ".getIoData()");
        PIHSCIOCIMClient pIHSCIOCIMClient = this.getIoClient(pIHscDlparCIMClient);
        Hashtable hashtable = new Hashtable();
        hashtable = pIHSCIOCIMClient.getIODrawerDataBeanHash(true);
        return hashtable;
    }

    private Vector setIoSlotStopped(PIHscDlparCIMClient pIHscDlparCIMClient, Hashtable hashtable, int n, short s) throws HSCRMCException, PIHscClientException {
        return this.setIoSlotState(pIHscDlparCIMClient, hashtable, false, n, s);
    }

    private Vector setIoSlotRunning(PIHscDlparCIMClient pIHscDlparCIMClient, Hashtable hashtable, int n, short s) throws HSCRMCException, PIHscClientException {
        return this.setIoSlotState(pIHscDlparCIMClient, hashtable, true, n, s);
    }

    private Vector setIoSlotState(PIHscDlparCIMClient pIHscDlparCIMClient, Hashtable hashtable, boolean bl, int n, short s) throws PIHscClientException, HSCRMCException {
        Vector vector = new Vector();
        String[] stringArray = (String[])hashtable.get("PhyLocCode");
        if (this.isRPA(pIHscDlparCIMClient)) {
            int n2 = this.mRMCClient.rmcDLPAROp(stringArray.length, n, s, "slot", stringArray, true == bl ? "a" : "r");
            return null;
        }
        UnsignedInt32[] unsignedInt32Array = (UnsignedInt32[])hashtable.get("DRCIndex");
        if (bl) {
            return this.varyOnIo(unsignedInt32Array, this.getPartitionSlotId(this.mIntName), n);
        }
        return this.varyOffIo(unsignedInt32Array, this.getPartitionSlotId(this.mIntName), n);
    }

    private boolean busHasActiveSlots(String string, int n, Hashtable hashtable) throws PIHscClientException {
        PIIOSlotDataBean[] pIIOSlotDataBeanArray = this.slotsAssignedToBus(string, n, hashtable);
        for (int i = 0; i < pIIOSlotDataBeanArray.length; ++i) {
            if (pIIOSlotDataBeanArray[i].getOwnerClass() == null || pIIOSlotDataBeanArray[i].getOwnerClass().shortValue() != 2 || pIIOSlotDataBeanArray[i].getOwnerId().intValue() != n) continue;
            System.out.println("partition has active slots under the PHB --  no need to vary PHB");
            return true;
        }
        System.out.println("partition has no slots under the PHB -- must vary PHB");
        return false;
    }

    private PIIOSlotDataBean[] slotsAssignedToBus(String string, int n, Hashtable hashtable) throws PIHscClientException {
        Object object;
        ArrayList<PIDataBeanInterface> arrayList = new ArrayList<PIDataBeanInterface>();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            PIIOSlotDataBean[] pIIOSlotDataBeanArray;
            PIDataBeanInterface pIDataBeanInterface;
            object = enumeration.nextElement();
            if (object instanceof PIIODrawerDataBean) {
                pIDataBeanInterface = (PIIODrawerDataBean)object;
                pIIOSlotDataBeanArray = this.slotsAssignedToBus(string, n, ((PIIODrawerDataBean)pIDataBeanInterface).getBuses());
                for (n2 = 0; n2 < pIIOSlotDataBeanArray.length; ++n2) {
                    arrayList.add(pIIOSlotDataBeanArray[n2]);
                }
            }
            if (object instanceof PIIOBusDataBean && ((PIIOBusDataBean)(pIDataBeanInterface = (PIIOBusDataBean)object)).getBusID().equals(string)) {
                pIIOSlotDataBeanArray = this.slotsAssignedToBus(string, n, ((PIIOBusDataBean)pIDataBeanInterface).getSlots());
                for (n2 = 0; n2 < pIIOSlotDataBeanArray.length; ++n2) {
                    arrayList.add(pIIOSlotDataBeanArray[n2]);
                }
            }
            if (!(object instanceof PIIOSlotDataBean) || (pIIOSlotDataBeanArray = ((PIIOSlotDataBean)(pIDataBeanInterface = (PIIOSlotDataBean)object)).getOwner()) == null || pIIOSlotDataBeanArray.intValue() != n) continue;
            arrayList.add(pIDataBeanInterface);
        }
        object = new PIIOSlotDataBean[arrayList.size()];
        object = (PIIOSlotDataBean[])arrayList.toArray((T[])object);
        return object;
    }

    private Hashtable varyOnOffPHB(String string, int n, short s, String string2, int n2, boolean bl) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        vector.addElement(new CIMProperty("PhbDrcName", new CIMValue((Object)string)));
        vector.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n))));
        vector.addElement(new CIMProperty("detailLevel", new CIMValue((Object)new UnsignedInt16((int)s))));
        vector.addElement(new CIMProperty("operation", new CIMValue((Object)string2)));
        vector.addElement(new CIMProperty("DestinationLparID", new CIMValue((Object)new UnsignedInt16(n2))));
        vector.addElement(new CIMProperty("noRMCConnection", new CIMValue((Object)new Boolean(bl))));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "varyOnOffPHB", vector, vector2);
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
            System.out.println("failed call to VARY_ON_OFF_PHB ");
            hashtable.put("IsError", new Boolean(true));
            hashtable.put("InfoMsg", throwable.getMessage());
            return hashtable;
        }
        Boolean bl2 = (Boolean)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
        String string3 = (String)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
        hashtable.put("IsError", bl2);
        hashtable.put("InfoMsg", string3);
        return hashtable;
    }

    private Vector varyOnIo(UnsignedInt32[] unsignedInt32Array, int n, int n2) throws PIHscClientException {
        return this.varyOnOffIo(unsignedInt32Array, true, n, n2);
    }

    private Vector varyOffIo(UnsignedInt32[] unsignedInt32Array, int n, int n2) throws PIHscClientException {
        return this.varyOnOffIo(unsignedInt32Array, false, n, n2);
    }

    private Vector varyOnOffIo(UnsignedInt32[] unsignedInt32Array, boolean bl, int n, int n2) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        vector.addElement(new CIMProperty("lparID", new CIMValue((Object)new UnsignedInt16(n))));
        vector.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n2))));
        vector.addElement(new CIMProperty("DRCIndex", new CIMValue((Object)unsignedInt32Array, new CIMDataType(25))));
        if (bl) {
            vector.addElement(new CIMProperty("op", new CIMValue((Object)new UnsignedInt8(1))));
        } else {
            vector.addElement(new CIMProperty("op", new CIMValue((Object)new UnsignedInt8(0))));
        }
        vector.addElement(new CIMProperty("clearFlag", new CIMValue((Object)new UnsignedInt8(0))));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, true == bl ? "varyOnIo" : "varyOffIo", vector, vector2);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        Object e = vector2.elementAt(0);
        Vector vector3 = null;
        vector3 = e instanceof CIMValue ? (Vector)((CIMValue)e).getValue() : (Vector)((CIMProperty)e).getValue().getValue();
        boolean[] blArray = new boolean[vector3.size()];
        String string = this.getSlotOutMessage(vector3, unsignedInt32Array, blArray);
        if (string != null) {
            Vector<Object> vector4 = new Vector<Object>();
            vector4.addElement(string);
            vector4.addElement(blArray);
            return vector4;
        }
        return null;
    }

    private PIHSCIOCIMClient getIoClient(PIHscDlparCIMClient pIHscDlparCIMClient) throws PIHscClientException {
        PIHSCIOCIMClient pIHSCIOCIMClient = null;
        String string = pIHscDlparCIMClient.getIntName().substring(pIHscDlparCIMClient.mIntName.indexOf("*") + 1);
        PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(pIHscDlparCIMClient.getHostName(), null);
        pIHSCIOCIMClient = pIHSCClientObjectFactory.createIOClient(string, new String[0], new String[0], new String[0], false);
        return pIHSCIOCIMClient;
    }

    private boolean isRPA(PIHscDlparCIMClient pIHscDlparCIMClient) throws PIHscClientException {
        return pIHscDlparCIMClient.getPartitionType().equals("RPA_PARTITION");
    }

    private boolean isOS400(PIHscDlparCIMClient pIHscDlparCIMClient) throws PIHscClientException {
        System.out.println("cimClient = " + pIHscDlparCIMClient);
        if (pIHscDlparCIMClient != null) {
            String string = pIHscDlparCIMClient.getPartitionType();
            System.out.println("part type : " + string);
            return string.equals("OS400_PARTITION");
        }
        return false;
    }

    private String lparStringId(HSCCIMClient hSCCIMClient) {
        String string = hSCCIMClient.getIntName();
        string = string.substring(0, string.indexOf("*"));
        return string;
    }

    private int lparId(HSCCIMClient hSCCIMClient) {
        return new Integer(this.lparStringId(hSCCIMClient));
    }

    private void checkSlotStatus(PIIOSlotDataBean pIIOSlotDataBean) throws PIHscClientException {
    }

    public void setLparInst(CIMInstance cIMInstance) {
        this.m_lparInst = cIMInstance;
    }

    public CIMInstance getLparInst() {
        return this.m_lparInst;
    }

    private void debug1(String string) {
        if (IDebug.enabled) {
            System.err.println("| DlparCIMClient." + string);
        }
    }

    private static void debug(String string) {
        System.err.println("| DlparCIMClient." + string);
    }

    private void printIoData(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            PIDataBeanInterface pIDataBeanInterface;
            Object v = enumeration.nextElement();
            if (v instanceof PIIODrawerDataBean) {
                pIDataBeanInterface = (PIIODrawerDataBean)v;
                System.err.println("JDS PIIODrawerDataBean: " + pIDataBeanInterface);
                this.printIoData(((PIIODrawerDataBean)pIDataBeanInterface).getBuses());
            }
            if (v instanceof PIIOBusDataBean) {
                pIDataBeanInterface = (PIIOBusDataBean)v;
                System.err.println("\tJDS PIIOBusDataBean: " + pIDataBeanInterface);
                this.printIoData(((PIIOBusDataBean)pIDataBeanInterface).getSlots());
            }
            if (!(v instanceof PIIOSlotDataBean)) continue;
            pIDataBeanInterface = (PIIOSlotDataBean)v;
            System.err.println("\t\tJDS PIIOSlotDataBean: drcIndex" + pIDataBeanInterface);
        }
    }

    private String getSlotOutMessage(Vector vector, Hashtable hashtable, boolean[] blArray) {
        boolean bl = false;
        String string = ERR_SLOT_HMC;
        UnsignedInt32[] unsignedInt32Array = null;
        String[] stringArray = null;
        unsignedInt32Array = (UnsignedInt32[])hashtable.get("DRCIndex");
        stringArray = (String[])hashtable.get("PhyLocCode");
        for (int i = 0; i < vector.size(); ++i) {
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)vector.elementAt(i);
            short s = unsignedInt8.shortValue();
            boolean bl2 = blArray[i] = s == 0;
            if (s == 0) continue;
            String string2 = null;
            string2 = s == 2 ? ERR_SLOT_REQUIRED : (s == 3 ? ERR_SLOT_NOT_STOPPED : (s == 4 ? ERR_SLOT_NOT_MATCH : (s == 5 ? ERR_SLOT_SAME_GROUP : (s == 6 ? ERR_SLOT_SRC_PAR : (s == 7 ? ERR_SLOT_OP_FAILED : "" + s)))));
            if (unsignedInt32Array != null) {
                long l = unsignedInt32Array[i].longValue();
                string = string + Long.toString(l, 16) + " " + string2 + "\n";
            } else {
                string = string + stringArray[i] + " " + string2 + "\n";
            }
            bl = true;
        }
        if (bl) {
            return string;
        }
        return null;
    }

    private String getSlotOutMessage(Vector vector, UnsignedInt32[] unsignedInt32Array, boolean[] blArray) {
        boolean bl = false;
        String string = ERR_SLOT_HMC;
        for (int i = 0; i < vector.size(); ++i) {
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)vector.elementAt(i);
            short s = unsignedInt8.shortValue();
            boolean bl2 = blArray[i] = s == 0;
            if (s == 0) continue;
            String string2 = null;
            string2 = s == 2 ? ERR_SLOT_REQUIRED : (s == 3 ? ERR_SLOT_NOT_STOPPED : (s == 4 ? ERR_SLOT_NOT_MATCH : (s == 5 ? ERR_SLOT_SAME_GROUP : (s == 6 ? ERR_SLOT_SRC_PAR : (s == 7 ? ERR_SLOT_OP_FAILED : "" + s)))));
            string = string + unsignedInt32Array[i].toString() + " " + string2 + "\n";
            bl = true;
        }
        if (bl) {
            return string;
        }
        return null;
    }

    private String getMessage(String string, String string2, Object[] objectArray) {
        String string3 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, string, string2, objectArray);
        this.mOutputStrHandler.handleOutputStr(string3);
        return string3;
    }

    private String getMessage(Throwable throwable) {
        String string = throwable.getMessage();
        this.mOutputStrHandler.handleOutputStr(string);
        return string;
    }

    private Hashtable slotInfoTrim(Hashtable hashtable, boolean[] blArray, boolean bl) {
        UnsignedInt32[] unsignedInt32Array = (UnsignedInt32[])hashtable.get("DRCIndex");
        String[] stringArray = (String[])hashtable.get("PhyLocCode");
        UnsignedInt16[] unsignedInt16Array = (UnsignedInt16[])hashtable.get("poolID");
        UnsignedInt16[] unsignedInt16Array2 = null;
        boolean bl2 = false;
        if (hashtable.get("lparID") == null) {
            bl2 = true;
            unsignedInt16Array2 = (UnsignedInt16[])hashtable.get("poolID");
        }
        Vector<UnsignedInt32> vector = new Vector<UnsignedInt32>();
        Vector<String> vector2 = new Vector<String>();
        Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>();
        Vector<UnsignedInt16> vector4 = new Vector<UnsignedInt16>();
        for (int i = 0; i < unsignedInt32Array.length; ++i) {
            if (blArray[i] == bl) continue;
            vector.addElement(unsignedInt32Array[i]);
            vector2.addElement(stringArray[i]);
            vector3.addElement(unsignedInt16Array[i]);
            if (!bl2) continue;
            vector4.addElement(unsignedInt16Array2[i]);
        }
        Hashtable<String, Object[]> hashtable2 = new Hashtable<String, Object[]>();
        int n = vector2.size();
        if (n == 0) {
            return hashtable2;
        }
        UnsignedInt32[] unsignedInt32Array2 = new UnsignedInt32[n];
        String[] stringArray2 = new String[n];
        UnsignedInt16[] unsignedInt16Array3 = new UnsignedInt16[n];
        UnsignedInt16[] unsignedInt16Array4 = new UnsignedInt16[n];
        hashtable2.put("DRCIndex", vector.toArray(unsignedInt32Array2));
        hashtable2.put("PhyLocCode", vector2.toArray(stringArray2));
        hashtable2.put("poolID", vector3.toArray(unsignedInt16Array3));
        if (bl2) {
            hashtable2.put("lparID", vector4.toArray(unsignedInt16Array4));
        }
        return hashtable2;
    }

    private Hashtable slotInfoTrim(Hashtable hashtable, int n, boolean bl) {
        String[] stringArray = (String[])hashtable.get("PhyLocCode");
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = i < n;
        }
        return this.slotInfoTrim(hashtable, blArray, bl);
    }

    public int createVirtualAdapter(Vector vector, int n, short s, boolean bl, String string) throws PIHscClientException {
        boolean bl2 = false;
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Object var9_9 = null;
        int n2 = 0;
        String string2 = this.getMessage("INFO_ADD_HMC", INFO_ADD_HMC, new String[]{INFO_VIRTUAL_RES});
        String string3 = this.getPartitionType();
        System.out.println(" In createVirtualAdapter");
        System.out.println("timeout = " + n);
        System.out.println("detailLevel = " + s);
        System.out.println("noRMCConnection = " + bl);
        System.out.println("resType = " + string);
        try {
            if (string.equals("eth")) {
                System.out.println("Calling the virtual ethernet add ");
                vector3 = this.hmcVirtualEthAdd(vector, n, s, bl);
                System.out.println("Done calling the hmcVirtualEthAdd ");
                System.out.println("The results size = " + vector3.size());
            } else if (string.equals("scsi") || string.equals("serial")) {
                System.out.println("Calling the virtual serial/scsi add ");
                vector3 = this.hmcVirtualSCSISerialAdd(vector, string, n, s, bl);
                System.out.println("Done calling the hmcVirtualSCSISerialAdd ");
                System.out.println("The results size = " + vector3.size());
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
            System.out.println("Got an Exception");
            string2 = string2 + throwable.getMessage();
            throw new PIHscClientException("294C", "HSCCIMExceptionBundle", "294C", new String[]{string2});
        }
        System.out.println("Finish the DLPAR operation  for add Virtual Adapter");
        if (vector3.size() == 1) {
            string2 = string2 + this.getMessage("INFO_ADD_SUCC", INFO_ADD_SUCC, new String[]{INFO_VIRTUAL_RES});
            n2 = (Integer)vector3.elementAt(0);
            return n2;
        }
        System.out.println("The results size is 2");
        string2 = string2 + (String)vector3.elementAt(0);
        System.out.println("The Add error message is :" + string2);
        throw new PIHscClientException("294C", "HSCCIMExceptionBundle", "294C", new String[]{string2});
    }

    private Vector hmcVirtualEthAdd(Vector vector, int n, short s, boolean bl) throws PIHscClientException {
        Object object;
        Object object2;
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Vector vector3 = new Vector();
        Vector<UnsignedInt16> vector4 = new Vector<UnsignedInt16>();
        Vector<UnsignedInt8> vector5 = new Vector<UnsignedInt8>();
        Vector<UnsignedInt16> vector6 = new Vector<UnsignedInt16>();
        Vector vector7 = new Vector();
        Vector<UnsignedInt16> vector8 = new Vector<UnsignedInt16>();
        Vector<UnsignedInt8> vector9 = new Vector<UnsignedInt8>();
        Vector<UnsignedInt8> vector10 = new Vector<UnsignedInt8>();
        System.out.println("In hmcVirtualEthAdd ---->");
        for (int i = 0; i < vector.size(); ++i) {
            object2 = (PIVirtualEthernetDataBean)vector.elementAt(i);
            vector4.add(((PIVirtualSlotDataBean)object2).getSlotNumber());
            vector5.add(((PIVirtualEthernetDataBean)object2).getIeee());
            vector6.add(((PIVirtualEthernetDataBean)object2).getPvid());
            object = ((PIVirtualEthernetDataBean)object2).getAdditionalVids();
            if (object != null) {
                System.out.println("The additional vlan ids vector is :" + ((UnsignedInt16[])object).length);
                vector8.add(new UnsignedInt16(((UnsignedInt16[])object).length));
                PIHscDlparCIMClient.addToVector(vector7, (UnsignedInt16[])object);
            } else {
                vector8.add(new UnsignedInt16(0));
            }
            vector9.add(((PIVirtualEthernetDataBean)object2).getTrunk());
            vector10.add(((PIVirtualSlotDataBean)object2).getRequired());
        }
        vector2.addElement(new CIMProperty("slotNum", new CIMValue(vector4, new CIMDataType(23))));
        vector2.addElement(new CIMProperty("ieee", new CIMValue(vector5, new CIMDataType(21))));
        vector2.addElement(new CIMProperty("vlanID", new CIMValue(vector6, new CIMDataType(23))));
        vector2.addElement(new CIMProperty("addLength", new CIMValue(vector8, new CIMDataType(23))));
        vector2.addElement(new CIMProperty("addVlanIDs", new CIMValue(vector7, new CIMDataType(23))));
        vector2.addElement(new CIMProperty("trunk", new CIMValue(vector9, new CIMDataType(21))));
        vector2.addElement(new CIMProperty("Required", new CIMValue(vector10, new CIMDataType(21))));
        vector2.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n))));
        vector2.addElement(new CIMProperty("detailLevel", new CIMValue((Object)new UnsignedInt8(s))));
        vector2.addElement(new CIMProperty("rmcConnection", new CIMValue((Object)new Boolean(bl))));
        try {
            System.out.println("Invoking the CIM method to add virtual ethernet");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "addVirtualEthernet", vector2, vector3);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            System.out.println("Got an exception invoking the CIM method");
            cIMException.printStackTrace();
            object2 = PIHscExceptionUtils.convert(cIMException);
            if (object2 == null) {
                object2 = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw object2;
        }
        System.out.println("Finished invoking the cim method to add virtual ethernet");
        Vector vector11 = null;
        if (vector3.size() > 0) {
            vector11 = GlobalConfig.callMethodsWithValues ? (Vector)((CIMValue)vector3.elementAt(0)).getValue() : (Vector)((CIMProperty)vector3.elementAt(0)).getValue().getValue();
        }
        System.out.println("Processing the results after the invoke method");
        object2 = this.getVirtualSlotOutMessage(vector11, vector4);
        object = new Vector();
        if (object2 != null) {
            ((Vector)object).addElement(object2);
            ((Vector)object).addElement(new Integer(vector4.size()));
        } else {
            ((Vector)object).addElement(new Integer(vector4.size()));
        }
        return object;
    }

    private Vector hmcVirtualSCSISerialAdd(Vector vector, String string, int n, short s, boolean bl) throws PIHscClientException {
        Object object;
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Vector vector3 = new Vector();
        Vector<UnsignedInt16> vector4 = new Vector<UnsignedInt16>();
        Vector<UnsignedInt8> vector5 = new Vector<UnsignedInt8>();
        Vector<UnsignedInt8> vector6 = new Vector<UnsignedInt8>();
        Vector<UnsignedInt8> vector7 = new Vector<UnsignedInt8>();
        Vector<UnsignedInt16> vector8 = new Vector<UnsignedInt16>();
        Vector<UnsignedInt16> vector9 = new Vector<UnsignedInt16>();
        Vector<UnsignedInt8> vector10 = new Vector<UnsignedInt8>();
        System.out.println("In hmcVirtualSCSISerialAdd ---->");
        for (int i = 0; i < vector.size(); ++i) {
            if (string.equals("scsi")) {
                System.out.println("Resource type SCSI hence loading the from the SCSI bean");
                object = (PIVirtualSCSIDataBean)vector.elementAt(i);
                vector5.add(DEVICE_CLASS_SCSI);
                vector7.add(NO_HMC_SUPPORT);
                vector4.add(((PIVirtualSlotDataBean)object).getSlotNumber());
                vector6.add(((PIVirtualSCSIDataBean)object).getDeviceAttributes());
                vector8.add(((PIVirtualSCSIDataBean)object).getServerPartitionID());
                vector9.add(((PIVirtualSCSIDataBean)object).getServerSlotNumber());
                vector10.add(((PIVirtualSlotDataBean)object).getRequired());
                continue;
            }
            if (!string.equals("serial")) continue;
            System.out.println("Resource type Serial hence loading the from the Serial bean");
            object = (PIVirtualSerialDataBean)vector.elementAt(i);
            vector5.add(DEVICE_CLASS_SERIAL);
            vector7.add(((PIVirtualSerialDataBean)object).getSupportsHMC());
            vector4.add(((PIVirtualSlotDataBean)object).getSlotNumber());
            vector6.add(((PIVirtualSerialDataBean)object).getDeviceAttributes());
            vector8.add(((PIVirtualSerialDataBean)object).getServerPartitionID());
            vector9.add(((PIVirtualSerialDataBean)object).getServerSlotNumber());
            vector10.add(((PIVirtualSlotDataBean)object).getRequired());
        }
        vector2.addElement(new CIMProperty("slotNum", new CIMValue(vector4, new CIMDataType(23))));
        vector2.addElement(new CIMProperty("deviceClass", new CIMValue(vector5, new CIMDataType(21))));
        vector2.addElement(new CIMProperty("deviceAttr", new CIMValue(vector6, new CIMDataType(21))));
        vector2.addElement(new CIMProperty("supportHMC", new CIMValue(vector7, new CIMDataType(21))));
        vector2.addElement(new CIMProperty("serverLparId", new CIMValue(vector8, new CIMDataType(23))));
        vector2.addElement(new CIMProperty("serverVirtualSlot", new CIMValue(vector9, new CIMDataType(23))));
        vector2.addElement(new CIMProperty("Required", new CIMValue(vector10, new CIMDataType(21))));
        vector2.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n))));
        vector2.addElement(new CIMProperty("detailLevel", new CIMValue((Object)new UnsignedInt8(s))));
        vector2.addElement(new CIMProperty("rmcConnection", new CIMValue((Object)new Boolean(bl))));
        System.out.println("The hostname is :" + this.mHostName);
        System.out.println("The Object path is :" + this.mObjectPath);
        System.out.println("The in parameters are :" + vector2);
        try {
            System.out.println("Invoking the CIM method to add virtual serial/SCSI");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "addVirtualSerialSCSI", vector2, vector3);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            System.out.println("Got an exception invoking the CIM method");
            cIMException.printStackTrace();
            object = PIHscExceptionUtils.convert(cIMException);
            if (object == null) {
                object = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw object;
        }
        System.out.println("Finished invoking the cim method to add virtual serial/scsi");
        Vector vector11 = null;
        if (vector3.size() > 0) {
            vector11 = GlobalConfig.callMethodsWithValues ? (Vector)((CIMValue)vector3.elementAt(0)).getValue() : (Vector)((CIMProperty)vector3.elementAt(0)).getValue().getValue();
        }
        System.out.println("Processing the results after the invoke method");
        object = this.getVirtualSlotOutMessage(vector11, vector4);
        System.out.println("The msg is :" + (String)object);
        Vector<Object> vector12 = new Vector<Object>();
        if (object != null) {
            vector12.addElement(object);
            vector12.addElement(new Integer(vector4.size()));
        } else {
            vector12.addElement(new Integer(vector4.size()));
        }
        return vector12;
    }

    public int removeVirtualSlots(Vector vector, int n, short s, boolean bl) throws PIHscClientException {
        System.out.println("In removeVirtualIo ###########");
        System.out.println("The slot Vector is :" + vector);
        System.out.println("timeout = " + n);
        System.out.println("detailLevel = " + s);
        System.out.println("noRMCConnection = " + bl);
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Vector vector3 = new Vector();
        vector2.addElement(new CIMProperty("slotNum", new CIMValue(vector, new CIMDataType(23))));
        vector2.addElement(new CIMProperty("timeout", new CIMValue((Object)new UnsignedInt16(n))));
        vector2.addElement(new CIMProperty("detailLevel", new CIMValue((Object)new UnsignedInt8(s))));
        vector2.addElement(new CIMProperty("rmcConnection", new CIMValue((Object)new Boolean(bl))));
        try {
            System.out.println("Invoking the CIM method to remove virtual adapters");
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "removeVirtualSlots", vector2, vector3);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            System.out.println("Got exception after the invoke Method");
            cIMException.printStackTrace();
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
        System.out.println("Finished invoking the cim method to add virtual ethernet");
        Vector vector4 = null;
        if (vector3.size() > 0) {
            vector4 = GlobalConfig.callMethodsWithValues ? (Vector)((CIMValue)vector3.elementAt(0)).getValue() : (Vector)((CIMProperty)vector3.elementAt(0)).getValue().getValue();
        }
        System.out.println("Processing the results after the invoke method");
        String string = this.getVirtualSlotOutMessage(vector4, vector);
        if (string != null) {
            System.out.println("The message after the remove virtual is :" + string);
            throw new PIHscClientException("294D", "HSCCIMExceptionBundle", "294D", new String[]{string});
        }
        return vector.size();
    }

    public static void addToVector(Vector vector, UnsignedInt16[] unsignedInt16Array) {
        for (int i = 0; i < unsignedInt16Array.length; ++i) {
            vector.addElement(unsignedInt16Array[i]);
        }
    }

    private String getVirtualSlotOutMessage(Vector vector, Vector vector2) {
        boolean bl = false;
        String string = ERR_VIRTUAL_HMC;
        for (int i = 0; i < vector.size(); ++i) {
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)vector.elementAt(i);
            short s = unsignedInt8.shortValue();
            System.out.println("The results array value is :" + s);
            if (s == 11) continue;
            String string2 = null;
            string2 = s == 13 ? ERR_SLOT_EXISTS : (s == 14 ? ERR_INVALID_SLOT_RANGE : (s == 15 ? ERR_INVALID_VLAN_RANGE : (s == 16 ? ERR_INVALID_ADD_VLAN_RANGE : (s == 17 ? ERR_ADD_VLAN_ID_NOT_ALLOWED : (s == 18 ? ERR_TOO_MANY_VLAN_IDS : (s == 19 ? ERR_DUPLICATE_VLAN_IDS : (s == 20 ? ERR_INVALID_IEEE_VALUE : (s == 21 ? ERR_SLOT_OP_FAILED : (s == 22 ? ERR_INVALID_DEVICE_ATTR_VALUE : (s == 23 ? ERR_INVALID_REQ_DES_FLAG : (s == 24 ? ERR_INVALID_SERV_SLOT_ID : (s == 25 ? ERR_INVALID_SERV_LPAR_ID : (s == 26 ? ERR_INVALID_HMC_SUPPORT_VALUE : (s == 27 ? ERR_VIRTUAL_DOES_NOT_EXISTS : (s == 28 ? ERR_GOT_EXCEPTION_CLEARING : (s == 29 ? ERR_INVALID_DEVICE_DEV_CLASS : (s == 30 ? ERR_GOT_EXCEPTION_VARYING_ONOFF : (s == 31 ? ERR_EXCEP_DRC_UNABLE_TO_UNSET : (s == 32 ? ERR_GOT_EXCEPTION_GETTING_DRCNAME_INDEX : (s == 33 ? ERR_RMC_OPERATION_FAILED : (s == 34 ? ERR_RMC_RESET_FAILED : (s == 35 ? ERR_VARYONOFF_RESET_FAILED : (s == 36 ? ERR_INVALID_TRUNK_VALUE : (s == 37 ? ERR_SCSI_SERVER_NOT_ALLOWED : (s == 38 ? ERR_SERIAL_CLIENT_NOT_ALLOWED : (s == 2 ? ERR_SLOT_REQUIRED : "" + s))))))))))))))))))))))))));
            string = string + vector2.elementAt(i) + " " + string2 + "\n";
            bl = true;
        }
        System.out.println("The found err flag is :" + bl);
        if (bl) {
            return string;
        }
        return null;
    }
}

